package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: phoenix-purconfig-service
 * @description: 发票认证条件配置
 * @author: cuixiangyu
 * @created: 2020-04-29 16:44
 */
@Data
public class AllAuthConditionBean extends BaseConfigItemBean{
    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    /** 认证条件(C01：需要影像识别信息；C02：需要销方协同信息；C03:需要查验成功；C04：强制检验发票抬头正确；C05：需要配单成功；C06：需要满足合规；C07：需要完成核销；
     * C08：需要完成付款；C09：需要完成记账；C10：需要完成审核；C11：需要签收；seNeedOfd: 电专需要ofd)*/
    public static enum ConditionEnum {
        C01, C02, C03, C04, C05, C06, C07, C08, C09, C10, C11, seNeedOfd;
    }

    public List<AllAuthConditionInfo> allAuthConditionList = new ArrayList<>();

    /** 一个业务类型下的认证条件 **/
    @Data
    public static class AllAuthConditionInfo {
        private String businessType;
        private List<AuthConditionInfo> authConditionList = new ArrayList<>();
        private String warnDay;
    }

    /** 认证条件对象 */
    @Data
    public static class AuthConditionInfo {
        private ConditionEnum condition;
        private CheckedFlagEnum checkedFlag;
    }
}
