package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: phoenix-purconfig-service
 * @description: 预警规则配置 自定义规则
 * @author: cuixiangyu
 * @created: 2020-03-04 13:42
 */
@Data
public class ComplianceCustomBean extends BaseConfigItemBean {

    /** 自定义规则配置列表 */
    private List<FieldInfo> fieldList = new ArrayList<>();

    /** 规则信息 */
    @Data
    public static class FieldInfo {
        /** 规则名称*/
        private String ruleName;
        /** 规则备注*/
        private String ruleRemark;
        /** 规则校验列表*/
        private List<RuleInfo> ruleItemList;
    }
    /** 规则校验信息*/
    @Data
    public static class RuleInfo {
        /** 校验字段*/
        private RuleItemName ruleItemName;
        /** 校验操作符*/
        private String ruleItemOperator;
        /** 校验值列表*/
        private List<String> ruleItemValue;
    }

    public static enum RuleItemName {
        cargoName, shortName, remark,
        purchaserName,purchaserTaxNo;
    }
}
