package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 合规配置 合规项选择
 *
 * @Author xiezhongyong
 * @Date 2019/7/1
 * @Version 1.0
 */
@Data
public class ComplianceSelectBean extends BaseConfigItemBean{

    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    /** 合规选择(C01: 校验多数据源信息比对不一致；C02：校验销方公司是否失信；C03：校验抬头是否有误；C04：校验发票明细是否存在敏感词；C05: 校验购方地址电话是否有误；
     * C06: 校验购方银行信息是否有误；C07: 校验发票是否红冲；C08: 校验发票是否作废；C09: 校验发票是否失控；C10: 校验发票是否退回；
     * C11: 校验发票抵扣后是否被红冲；C12：校验发票抵扣后是否被作废；C13：校验购方公司是否存在)；sellerNameSenseWord：校验销方公司敏感词*/
    public static enum ConditionEnum {
        C01, C02, C03, C04, C05, C06, C07, C08, C09, C10, C11, C12, C13, sellerNameSenseWord;
    }

    public List<SelectConditionInfo> selectConditionList = new ArrayList<>();

    /** 选择项对象 */
    @Data
    public static class SelectConditionInfo {
        private ConditionEnum condition;
        private CheckedFlagEnum checkedFlag;
    }



}
