package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 发票配单 ： 是否启用自动配单
 *
 * @Author cuixiangyu
 * @Date 2019/12/10
 * @Version 1.0
 */
@Data
public class MatchConditionAutoBean extends BaseConfigItemBean{

    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    /** 配单条件(C01：启用自动配单； C02：不启用自动配单) */
    public static enum ConditionEnum {
        C01, C02;
    }

    public List<MatchConditionAutoBean.AuthConditionInfo> matchConditionAutoList = new ArrayList<>();

    /** 认证条件对象 */
    @Data
    public static class AuthConditionInfo {
        private MatchConditionAutoBean.ConditionEnum condition;
        private MatchConditionAutoBean.CheckedFlagEnum checkedFlag;
    }
}
