package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 发票配单 ： 配单条件
 *
 * @Author xiezhongyong
 * @Date 2019/9/17
 * @Version 1.0
 */
@Data
public class MatchConditionBean extends BaseConfigItemBean{

    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    /** 配单条件(C01：验真成功； C02：影像信息已获取；C03：已记账；C04：已付款) */
    public static enum ConditionEnum {
        C01, C02, C03, C04;
    }

    public List<AuthConditionInfo> matchConditionList = new ArrayList<>();

    /** 认证条件对象 */
    @Data
    public static class AuthConditionInfo {
        private ConditionEnum condition;
        private CheckedFlagEnum checkedFlag;
        private double value;
    }
}
