package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 单据不可取消配单条件
 *
 * @Author cuixiangyu
 * @Date 2020/1/3
 * @Version 1.0
 */
@Data
public class MatchConditionBillBean extends BaseConfigItemBean {

    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    /** 配单条件(C01：单据已记账； C02：单据已付款) */
    public static enum ConditionEnum {
        C01, C02;
    }

    public List<AuthConditionInfo> matchConditionBill = new ArrayList<>();

    /** 认证条件对象 */
    @Data
    public static class AuthConditionInfo {
        private ConditionEnum condition;
        private CheckedFlagEnum checkedFlag;
        private double value;
    }
}
