package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class MatchConditionDetailBean extends BaseConfigItemBean {

    /**
     * 是否选择(NO:否，YES:是)
     */
    public static enum CheckedFlagEnum {
        YES, NO;
    }

    /**
     * 配单商品校验(C01：别名； C02：数量； C03：不含税金额； C04：税额)
     */
    public static enum ConditionEnum {
        C01, C02, C03, C04;
    }

    public List<MatchConditionDetailBean.AuthConditionInfo> matchConditionDetail = new ArrayList<>();

    /**
     * 认证条件对象
     */
    @Data
    public static class AuthConditionInfo {
        private MatchConditionDetailBean.ConditionEnum condition;
        private MatchConditionDetailBean.CheckedFlagEnum checkedFlag;
        private double value;
    }
}
