package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import javax.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 影像采集--自定义字段配置项
 *
 * @Author xiezhongyong
 * @Date 2019/6/11
 * @Version 1.0
 */

@Data
@Slf4j
public class RecogCustomFieldBean extends BaseConfigItemBean {

    
    public static enum StateEnum{
        YES,NO;
    }
    public static enum FieldTypeEnum{
        RADIO,CHECKBOX,DATETIME,TEXT,RANDOM;
    }
    public static enum EntryEnum{
        MANUL,BILL;
    }

    /**
     * 影像识别是否启用自定义字段(NO:否，YES:是)
     **/
    private StateEnum enabledFlag;

    /**
     * 字段配置列表
     */
    @NotEmpty
    private List<FieldInfo> fieldList = new ArrayList<>();

    @Data
    public static class FieldInfo{
        /**
         * 字段名称
         **/
        @NotEmpty
        private String fieldName;

        /**
         * 字段类型(字段类型，RADIO:单选，CHECKBOX:多选，DATETIME:时间，TEXT:文本)
         **/
        private FieldTypeEnum fieldType;

        /**
         * 是否必填(NO:否，YES:是)
         **/
        private StateEnum requiredFlag;

        /**
         * 录入方式(MANUL:手工录入，BILL:单据继承)
         */
        private EntryEnum entryType;

        /**
         * 值列表
         **/
        private List<ValueInfo> valueList = new ArrayList<>();

    }
    /**
     * 值 对象
     */
    @Data
    public static class ValueInfo {
        /**
         * 值
         **/
        private String value;
        /**
         * 是否为默认值(NO:否，YES:是)
         **/
        private StateEnum defaultFlag;
    }
}


