package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: phoenix-purconfig-service
 * @description: 异常发票提交条件
 * @author: cuixiangyu
 * @created: 2020-05-18 13:41
 */
@Data
public class SubmitAbnormalConditionBean extends BaseConfigItemBean{

    /** 异常发票提交条件 purchaseNameUnEqCompanyName: 购方名称与法人公司名称不一致,purchaseTaxNoUnEqCompanyTaxNo:购方税号与购方税号不一致,
     * sellerInBlackList:发票销方为黑名单,isOcc:已占用发票,isRepeat:已重复发票,containSensitiveWords:发票明细中存在敏感词,
     * unVerify:发票未验真,verifyFailed:发票验真失败*/
    public static enum ConditionEnum {
        purchaseNameUnEqCompanyName, purchaseTaxNoUnEqCompanyTaxNo, sellerInBlackList, isOcc,
        isRepeat, containSensitiveWords, unVerify, verifyFailed;
    }

    public List<AbnormalConditionInfo> abnormalConditionInfoList = new ArrayList<>();

    /** 选择项对象 */
    @Data
    public static class AbnormalConditionInfo {
        private ConditionEnum condition;
        private Integer checkedFlag;
    }
}
