package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: phoenix-purconfig-service
 * @description: 发票种类提交条件
 * @author: cuixiangyu
 * @created: 2020-05-18 13:41
 */
@Data
public class SubmitInvoiceTypeBean extends BaseConfigItemBean{

    /** 票种枚举,c-普票，ce电票，s-专票，se-电专，bc-区块链，quota-定额，toll-过路费，veh-机动车，taxi-出租车，
     * train-火车票，usedVeh-二手车，plane-行程单飞机票，bus-客运汽车/船票, other-其他发票*/
    public static enum TypeEnum {
        c,ce,s,se,bc,quota,toll,veh,taxi,train,usedVeh,plane,bus,other;
    }

    public List<InvoiceTypeBean> invoiceTypeList = new ArrayList<>();

    /** 一个业务类型下的认证条件 **/
    @Data
    public static class InvoiceTypeBean {
        private TypeEnum type;
        private Integer checkedFlagEnum;
    }

}
