package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: phoenix-purconfig-service
 * @description: 业务标签配置
 * @author: cuixiangyu
 * @created: 2020-04-14 14:02
 */
@Data
public class TagTagList extends BaseConfigItemBean{

    /** 业务标签配置列表 */
    private List<TagInfo> tagList = new ArrayList<>();

    /** 业务标签规则列表 */
    @Data
    public static class TagInfo {
        /** 业务标签名称*/
        private String tagName;
        /** 业务标签校验列表*/
        private List<TagItemInfo> tagItemList;
    }
    /** 业务标签校验信息*/
    @Data
    public static class TagItemInfo {
        /** 校验字段*/
        private TagItemName tagItemName;
        /** 校验操作符*/
        private String tagItemOperator;
        /** 校验值列表*/
        private List<String> tagItemValue;
    }

    public static enum TagItemName {
        cargoName, shortName;
    }
}
