package com.xforceplus.purconfig.client.model.config.item;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 发票查验 票种
 *
 * @Author xiezhongyong
 * @Date 2019/6/27
 * @Version 1.0
 */
@Data
public class VerifyInvoiceTypeBean extends BaseConfigItemBean{

    /**
     * 发票类型
     * S-增值税专用发票
     * C-增值税普通发票
     * CE-增值税电子普通发票
     * JU-增值税普通发票（卷票）
     * CT-通行费增值税电子普通发票
     * V-机动车统一销售发票
     * SE-增值税电子专用发票
     **/
    public static enum InvoiceTypeEnum {
        S, C, CE, JU, CT, V, SE;
    }
    /** 是否选择(NO:否，YES:是) */
    public static enum CheckedFlagEnum {
        YES, NO;
    }
    public List<InvoiceTypeInfo> invoiceTypeList = new ArrayList<>();

    @Data
    public static class InvoiceTypeInfo {
        private InvoiceTypeEnum type;
        private CheckedFlagEnum checkedFlag;
        private String minAmount;
        private String maxAmount;
    }


}
