/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillMainExtMapper;
import com.xforceplus.phoenix.bill.client.model.QueryBillModel;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillItemByBillNoQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillItemByBillNoQueryAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private BillMainExtMapper billMainExtMapper;

    public Object process(AdapterParams param) {
        Map params = param.getParams();
        String tenantId = param.getTenantId();
        QueryBillModel parse = (QueryBillModel)params.get("model");
        BillMainQueryRequest queryRequest = new BillMainQueryRequest();
        queryRequest.setBillNos(Arrays.asList(parse.getSalesbillNo()));
        log.info("queryBillByBillNosRequest:{}", (Object)queryRequest);
        Response response = this.billMainClient.queryBills(tenantId, queryRequest);
        return this.billMainExtMapper.mapToBillMainExtList((List)response.getResult());
    }

    public String adapterName() {
        return "querySalesbillByBillNo";
    }
}

