/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillSourceClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.TargetBillNoRequest;
import com.xforceplus.phoenix.bill.client.model.TargetBillNoResponse;
import com.xforceplus.receipt.vo.BillSource;
import com.xforceplus.receipt.vo.request.BillSourceRelQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryTargetBillNoAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillSourceClient billSourceClient;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        TargetBillNoRequest request = (TargetBillNoRequest)params.get("targetBillNoRequest");
        BillSourceRelQueryRequest queryRequest = new BillSourceRelQueryRequest();
        queryRequest.setTargetBillIds(Collections.singletonList(Long.valueOf(request.getBillId())));
        Response source = this.billSourceClient.queryBillSource(tenantId, queryRequest);
        TargetBillNoResponse response = new TargetBillNoResponse();
        if (source.isOk()) {
            response.setCode(Integer.valueOf(1));
            response.setBillNoList(((List)source.getResult()).stream().map(BillSource::getBillNo).collect(Collectors.toList()));
        } else {
            response.setCode(Integer.valueOf(0));
            response.setMessage(source.getMessage());
        }
        return response;
    }

    public String adapterName() {
        return "queryTargetBillNo";
    }
}

