/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.BillMatchInvoiceVo;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceStatus;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillMatchInvoiceComponent {
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private BillOperationAdapterService operationAdapterService;

    public List<BillMatchInvoiceVo> createVo(List<Long> itemIds, Long invoiceId, String invoiceNo, String invoiceCode, Integer invoiceOrigin, String tenantId) {
        List<Object> mains = Lists.newArrayList();
        List<List<Long>> lists = this.averageAssign(itemIds, 2000);
        for (List<Long> list : lists) {
            Response mainResult;
            if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty((Collection)((Collection)(mainResult = this.mainClient.queryBillsByItemIds(tenantId, list)).getResult()))) continue;
            mains.addAll((Collection)mainResult.getResult());
        }
        if (!CollectionUtils.isEmpty((Collection)mains)) {
            List billIds = mains.stream().map(BillMain::getId).collect(Collectors.toList());
            List list = this.operationAdapterService.queryAlreadyBillMatchRel(billIds, invoiceNo, invoiceCode);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                mains = mains.stream().filter(m -> !list.contains(m.getId())).collect(Collectors.toList());
            }
            return mains.stream().map(bill -> {
                BillMatchInvoiceVo osbm = new BillMatchInvoiceVo();
                osbm.setInvoiceId(invoiceId);
                osbm.setInvoiceCode(invoiceCode);
                osbm.setInvoiceNo(invoiceNo);
                osbm.setSalesbillNo(bill.getBillNo());
                osbm.setAmountWithoutTax(bill.getAmountWithoutTax());
                osbm.setAmountWithTax(bill.getAmountWithTax());
                osbm.setTaxAmount(bill.getTaxAmount());
                osbm.setSalesbillId(bill.getId());
                osbm.setOpType(invoiceOrigin);
                osbm.setStatus(BillInvoiceStatus.MatchedBill.value());
                return osbm;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public void saveBillMatchInvoice(List<BillMatchInvoiceVo> matchInvoiceVos) {
        this.operationAdapterService.saveBillMatchInvoice(matchInvoiceVos);
    }

    public <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}

