/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.alibaba.fastjson.JSON;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.model.ItemMapping;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.SplitGroup;
import com.xforceplus.phoenix.bill.client.enums.BillMergeType;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.receipt.dto.config.CombinationField;
import com.xforceplus.receipt.enums.FunctionFlag;
import com.xforceplus.receipt.vo.BillDetail;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.CombineConfigParamAssembly;
import com.xforceplus.receipt.vo.MergeConfigParamAssembly;
import com.xforceplus.receipt.vo.request.BillMergeDetail;
import com.xforceplus.receipt.vo.request.BillMergeRequest;
import com.xforceplus.receipt.vo.response.MergeResponse;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.config.client.constant.MergeRuleEnum;
import com.xforceplus.seller.config.client.constant.SecondMergeRuleEnum;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.BillMergeParser;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillAutoMergeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillAutoMergeAdapter.class);
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private BillMergeParser billMergeParser;
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;
    @Autowired
    private OrdSalesbillItemVoMapper ordSalesbillItemVoMapper;
    private static final Map<String, Field> voFields = new HashMap<String, Field>();

    public Object process(AdapterParams adapterParams) {
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Map extOutOrdSalesbillDetailVO2CombRuleMap = (Map)paramMap.get("extOutOrdSalesbillDetailVO2CombRuleMap");
        MakeOutInvoiceResponse failResponse = new MakeOutInvoiceResponse().code(com.xforceplus.xplatframework.model.Response.Fail);
        List outSplitGroupList = (List)paramMap.get("outSplitGroupList");
        for (Map.Entry ruleEntry : extOutOrdSalesbillDetailVO2CombRuleMap.entrySet()) {
            BillMergerRuleDTO ruleBean;
            MsConfigBean bean = (MsConfigBean)ruleEntry.getValue();
            List itemList = bean.getItemList();
            BillMergerRuleDTO billMergerRuleDTO = ruleBean = this.billMergeParser.parse(itemList);
            log.info("\u7ec4\u5408\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoAssociationFlag());
            log.info("\u5408\u5e76\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoMergeFlag());
            log.debug("MergeRule{}", (Object)billMergerRuleDTO.getMergeRule());
            log.info("RuleId{}", (Object)billMergerRuleDTO.getRuldId());
            List vo = (List)ruleEntry.getKey();
            try {
                BillMergeRequest request = this.processParams(billMergerRuleDTO, vo);
                this.requestMerge(tenantId, request, outSplitGroupList, billMergerRuleDTO, vo);
                failResponse.setCode(com.xforceplus.xplatframework.model.Response.OK);
            }
            catch (IllegalArgumentException e) {
                failResponse.setCode(com.xforceplus.xplatframework.model.Response.Fail);
                failResponse.setMessage(e.getMessage());
                return failResponse;
            }
        }
        return null;
    }

    public String adapterName() {
        return "salesBillGroup";
    }

    public static String getInvoiceType(OrdSalesbillDetailVO ordSalesbillDetailVO) {
        OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
        OrdSalesbillItemVO ordSalesbillItemVO = ordSalesbillDetailVO.getOrdSalesbillItemVO();
        String invoiceType = StringUtils.isBlank((CharSequence)ordSalesbillItemVO.getInvoiceType()) ? ordSalesbillVO.getInvoiceType() : ordSalesbillItemVO.getInvoiceType();
        return invoiceType;
    }

    private List<MergeConfigParamAssembly> parseMergeConfig(BillMergerRuleDTO billMergerRuleDTO) {
        ArrayList<MergeConfigParamAssembly> mergeConfigParamAssemblies = new ArrayList<MergeConfigParamAssembly>();
        if (billMergerRuleDTO.getAutoMergeFlag().booleanValue()) {
            MergeConfigParamAssembly mergeConfig = new MergeConfigParamAssembly();
            List mergeConditions = billMergerRuleDTO.getMergerCondition().stream().map(x -> {
                CombinationField combinationField = new CombinationField();
                switch (x.getFieldGroupIndex()) {
                    case 0: {
                        combinationField.setField(MainMapping.getField((String)x.getField()));
                        combinationField.setType(CombinationField.FieldType.MAIN);
                        break;
                    }
                    case 1: {
                        combinationField.setField(ItemMapping.getField((String)x.getField()));
                        combinationField.setType(CombinationField.FieldType.ITEM);
                        break;
                    }
                    default: {
                        log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                        throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                    }
                }
                return combinationField;
            }).collect(Collectors.toList());
            mergeConfig.setConditions(mergeConditions);
            Integer negativeRule = billMergerRuleDTO.getNagertiveRule().getvalue();
            String negativeRuleStr = JSON.toJSONString(Collections.singletonMap("negativeRule", negativeRule));
            mergeConfig.setParams(negativeRuleStr);
            MergeRuleEnum mergeRule = billMergerRuleDTO.getMergeRule();
            switch (mergeRule) {
                case quantity_add: {
                    mergeConfig.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
                    break;
                }
                case quantity_merge_To_One: {
                    mergeConfig.setFunctionName(FunctionFlag.QUANTITY_MERGE_TO_ONE.name());
                    break;
                }
                case no_quantity_no_Price: {
                    mergeConfig.setFunctionName(FunctionFlag.NO_QUANTITY_NO_PRICE.name());
                    break;
                }
                case save_price: {
                    mergeConfig.setFunctionName(FunctionFlag.KEEP_PRICE.name());
                    break;
                }
                default: {
                    log.info("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:[{}]", (Object)mergeRule);
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:" + mergeRule);
                }
            }
            mergeConfigParamAssemblies.add(mergeConfig);
            if (billMergerRuleDTO.getSecondMergeFlag().booleanValue()) {
                MergeConfigParamAssembly assemblyTwo = new MergeConfigParamAssembly();
                assemblyTwo.setFunctionName(FunctionFlag.NEGATIVE_OFFSET.name());
                List secondCondition = billMergerRuleDTO.getSecondMergeCondition().stream().map(x -> {
                    CombinationField combinationField = new CombinationField();
                    switch (x.getFieldGroupIndex()) {
                        case 0: {
                            combinationField.setType(CombinationField.FieldType.MAIN);
                            combinationField.setField(MainMapping.getField((String)x.getField()));
                            break;
                        }
                        case 1: {
                            combinationField.setType(CombinationField.FieldType.ITEM);
                            combinationField.setField(ItemMapping.getField((String)x.getField()));
                            break;
                        }
                        default: {
                            log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                            throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                        }
                    }
                    return combinationField;
                }).collect(Collectors.toList());
                assemblyTwo.setConditions(secondCondition);
                SecondMergeRuleEnum secondNagertiveRule = billMergerRuleDTO.getSecondNagertiveRule();
                if (secondNagertiveRule == null) {
                    throw new IllegalArgumentException("\u7b2c\u4e8c\u6b21\u5408\u5e76\u6761\u4ef6\u5408\u5e76\u7ed3\u679c\u662f\u5426\u5141\u8bb8\u6b63\u8d1f\u4e3a\u7a7a");
                }
                switch (secondNagertiveRule) {
                    case SECOND_MERGE_RESULT_NEGATIVE: {
                        assemblyTwo.setParams(JSON.toJSONString(Collections.singletonMap("forbidNegative", 0)));
                        break;
                    }
                    case SECOND_MERGE_RESULT_NO_NEGATIVE: {
                        assemblyTwo.setParams(JSON.toJSONString(Collections.singletonMap("forbidNegative", 1)));
                        break;
                    }
                }
                mergeConfigParamAssemblies.add(assemblyTwo);
            }
        } else {
            MergeConfigParamAssembly mergeConfig = new MergeConfigParamAssembly();
            CombinationField combinationField = new CombinationField();
            combinationField.setField("id");
            combinationField.setType(CombinationField.FieldType.ITEM);
            mergeConfig.setConditions(Collections.singletonList(combinationField));
            mergeConfig.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
            mergeConfigParamAssemblies.add(mergeConfig);
        }
        return mergeConfigParamAssemblies;
    }

    private List<CombineConfigParamAssembly> parseCombineConfig(BillMergerRuleDTO billMergerRuleDTO) {
        ArrayList<CombineConfigParamAssembly> combineConfigs = new ArrayList<CombineConfigParamAssembly>();
        if (billMergerRuleDTO.getAutoAssociationFlag().booleanValue()) {
            List combinationFields = null;
            if (CollectionUtils.isNotEmpty((Collection)billMergerRuleDTO.getAssociationCondition())) {
                combinationFields = billMergerRuleDTO.getAssociationCondition().stream().map(x -> {
                    if (x.getFieldGroupIndex() == null) {
                        log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex\u4e0d\u80fd\u4e3a\u7a7a");
                        throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    CombinationField combinationField = new CombinationField();
                    switch (x.getFieldGroupIndex()) {
                        case 0: {
                            combinationField.setField(MainMapping.getField((String)x.getField()));
                            combinationField.setType(CombinationField.FieldType.MAIN);
                            break;
                        }
                        case 1: {
                            combinationField.setField(ItemMapping.getField((String)x.getField()));
                            combinationField.setType(CombinationField.FieldType.ITEM);
                            break;
                        }
                        default: {
                            log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                            throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                        }
                    }
                    return combinationField;
                }).collect(Collectors.toList());
            } else {
                log.info("\u7ec4\u5408\u6761\u4ef6\u4e3a\u7a7a");
            }
            CombineConfigParamAssembly config = new CombineConfigParamAssembly();
            config.setFunctionName("COMMON_COMBINER");
            config.setConditions(combinationFields);
            combineConfigs.add(config);
            CombineConfigParamAssembly phoenixConfig = new CombineConfigParamAssembly();
            phoenixConfig.setParams(JSON.toJSONString(Collections.singletonMap("autoMerge", billMergerRuleDTO.getAutoMergeFlag())));
            phoenixConfig.setFunctionName("PHOENIX_BILL_COMBINER");
            CombineConfigParamAssembly zeroAmount = this.getCombineConfigByBillNoAndInvoiceType();
            zeroAmount.setFunctionName("ZERO_AMOUNT_COMBINER");
            zeroAmount.setParams(JSON.toJSONString(Collections.singletonMap("allowZeroAmount", 1)));
            combineConfigs.add(zeroAmount);
        } else {
            CombineConfigParamAssembly noAutoCombine = this.getCombineConfigByBillNoAndInvoiceType();
            noAutoCombine.setFunctionName("COMMON_COMBINER");
            noAutoCombine.setParams(JSON.toJSONString(Collections.singletonMap("allowOne", 2)));
            combineConfigs.add(noAutoCombine);
        }
        CombineConfigParamAssembly zeroCombine2 = this.getCombineConfigByBillNoAndInvoiceType();
        zeroCombine2.setFunctionName("ZERO_AMOUNT_COMBINER");
        zeroCombine2.setParams(JSON.toJSONString(Collections.singletonMap("allowZeroAmount", 2)));
        combineConfigs.add(zeroCombine2);
        return combineConfigs;
    }

    private BillMergeRequest processParams(BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vo) {
        BillMergeRequest request = new BillMergeRequest();
        List<CombineConfigParamAssembly> combineConfigParamAssemblies = this.parseCombineConfig(billMergerRuleDTO);
        request.setCombineConfigs(combineConfigParamAssemblies);
        List<MergeConfigParamAssembly> mergeConfigParamAssemblies = this.parseMergeConfig(billMergerRuleDTO);
        request.setMergeConfigs(mergeConfigParamAssemblies);
        HashMap map = vo.stream().collect(Collectors.groupingBy(x -> x.getOrdSalesbillVO().getSalesbillId(), HashMap::new, Collectors.mapping(x -> x.getOrdSalesbillItemVO().getSalesbillItemId(), Collectors.toList())));
        ArrayList details = new ArrayList();
        map.forEach((k, v) -> {
            BillMergeDetail detail = new BillMergeDetail();
            detail.setBillId(k);
            detail.setItemIds(v);
            details.add(detail);
        });
        request.setBills(details);
        return request;
    }

    private CombineConfigParamAssembly getCombineConfigByBillNoAndInvoiceType() {
        CombineConfigParamAssembly combineConfig = new CombineConfigParamAssembly();
        ArrayList<CombinationField> combineFields = new ArrayList<CombinationField>();
        CombinationField billNo = new CombinationField();
        billNo.setField(MainMapping.getField((String)"billNo"));
        billNo.setType(CombinationField.FieldType.MAIN);
        combineFields.add(billNo);
        CombinationField invoiceType = new CombinationField();
        invoiceType.setField(ItemMapping.getField((String)"invoiceType"));
        invoiceType.setType(CombinationField.FieldType.ITEM_PRIORITY);
        combineFields.add(invoiceType);
        combineConfig.setConditions(combineFields);
        return combineConfig;
    }

    private void requestMerge(String tenantId, BillMergeRequest request, List outSplitGroupList, BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vo) {
        Response response = this.billMainClient.mergeAuto(tenantId, request);
        if (response.isOk()) {
            OrdSalesbillDetailVO detailVO = vo.get(0);
            OrdSalesbillVO billVO = detailVO.getOrdSalesbillVO();
            billVO.setInvoiceType(BillAutoMergeAdapter.getInvoiceType(detailVO));
            BaseRuleBean baseRuleBean = this.billAdapterService.getBaseRuleBean(billVO);
            MergeResponse mergeResponse = (MergeResponse)response.getResult();
            List bills = mergeResponse.getBills();
            List nonMerge = mergeResponse.getNonMerge();
            if (CollectionUtils.isNotEmpty((Collection)bills)) {
                ArrayList mergeVo = new ArrayList();
                for (Object bill2 : bills) {
                    List<OrdSalesbillItemVO> ordSalesbillItemVOS = this.ordSalesbillItemVoMapper.mapToItemVoList(bill2.getItems());
                    OrdSalesbillVO ordSalesbillVO = this.ordSalesbillVoMapper.mapToBillVo(bill2.getMain());
                    ordSalesbillItemVOS.forEach(item -> mergeVo.add(new OrdSalesbillDetailVO(ordSalesbillVO, item)));
                }
                SplitGroup splitGroup = SplitGroup.builder().ruleId(baseRuleBean.getRuldId()).mergeType(Integer.valueOf(billMergerRuleDTO.getAutoMergeFlag() != false ? BillMergeType.AUTO_MERGE.value() : BillMergeType.AUTO_COMBINE.value())).batchNo(((BillItem)((BillDetail)bills.get(0)).getItems().get(0)).getBatchNo()).build();
                splitGroup.setList(mergeVo);
                outSplitGroupList.add(splitGroup);
            }
            if (CollectionUtils.isNotEmpty((Collection)nonMerge)) {
                ArrayList nonVo = new ArrayList();
                AtomicLong batchNo = new AtomicLong(0L);
                for (MergeResponse.NonMergeBillVo nonMergeBillVo : nonMerge) {
                    nonMergeBillVo.getBills().forEach(bill -> {
                        List<OrdSalesbillItemVO> ordSalesbillItemVOS = this.ordSalesbillItemVoMapper.mapToItemVoList(bill.getItems());
                        if (batchNo.get() == 0L) {
                            batchNo.set(((BillItem)bill.getItems().get(0)).getBatchNo());
                        }
                        OrdSalesbillVO ordSalesbillVO = this.ordSalesbillVoMapper.mapToBillVo(bill.getMain());
                        ordSalesbillItemVOS.forEach(item -> nonVo.add(new OrdSalesbillDetailVO(ordSalesbillVO, item)));
                    });
                }
                SplitGroup splitGroup = SplitGroup.builder().ruleId(baseRuleBean.getRuldId()).mergeType(Integer.valueOf(BillMergeType.NONE.value())).batchNo(Long.valueOf(batchNo.get())).build();
                splitGroup.setList(nonVo);
                outSplitGroupList.add(splitGroup);
            }
        }
    }
}

