/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SellerBillInfoMapper;
import com.xforceplus.adapter.mapstruct.SellerBillItemMapper;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.SplitGroup;
import com.xforceplus.phoenix.bill.client.enums.BillMergeType;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.MakeoutInvoiceRequest;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.api.BillUpdateApi;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.enums.SplitType;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceResponse;
import com.xforceplus.xplatframework.apimodel.AsyncModel;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.util.CommonTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessMakeOutInvoiceAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(ProcessMakeOutInvoiceAdapter.class);
    @Value(value="${bill.new.make.out}")
    private int billNewMakeOut;
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private SellerBillItemMapper sellerBillItemMapper;
    @Autowired
    private SellerBillInfoMapper sellerBillInfoMapper;
    @Autowired
    private BillUpdateApi billUpdateApi;

    public Object process(AdapterParams adapterParams) {
        SplitPreInvoiceResponse splitPreInvoiceResponse;
        List outSplitGroupList = (List)adapterParams.getParams().get("outSplitGroupList");
        MakeoutInvoiceRequest makeoutInvoiceRequest = (MakeoutInvoiceRequest)adapterParams.getParams().get("makeoutInvoiceRequest");
        Long tmpRuleId = (Long)adapterParams.getParams().get("tmpRuleId");
        SearchSort sort = (SearchSort)adapterParams.getParams().get("sort");
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            if (CommonTools.isEmpty((List)outSplitGroupList)) {
                throw new IllegalArgumentException("\u65e0\u6570\u636e\u62c6\u7968.");
            }
            String operatorUser = "\u7cfb\u7edf";
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            log.info("splitAndMakeOutUser:{}", (Object)JsonUtils.writeObjectToFastJson((Object)userInfo));
            if (userInfo != null) {
                operatorUser = userInfo.getUserName();
            }
            HashSet<Long> set = new HashSet<Long>();
            ArrayList<SplitPreInvoiceRequest> splitPreInvoiceRequestList = new ArrayList<SplitPreInvoiceRequest>();
            HashMap<Long, List> noneMergeItems = new HashMap<Long, List>();
            HashMap<Long, List> mergeItems = new HashMap<Long, List>();
            HashMap noneMergeBill = new HashMap();
            HashMap mergeBill = new HashMap();
            for (SplitGroup splitGroup : outSplitGroupList) {
                List<OrdSalesbillItemVO> itemVOS = splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillItemVO).collect(Collectors.toList());
                splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> noneMergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                if (Objects.equals(splitGroup.getMergeType(), BillMergeType.NONE.value())) {
                    splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> noneMergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                    noneMergeItems.computeIfAbsent(splitGroup.getBatchNo(), k -> new ArrayList()).addAll(this.sellerBillItemMapper.mapToBillItems(itemVOS));
                    continue;
                }
                splitGroup.getList().stream().map(OrdSalesbillDetailVO::getOrdSalesbillVO).forEach(x -> mergeBill.put(x.getSalesbillId(), this.sellerBillInfoMapper.mapToBillInfo((OrdSalesbillVO)x)));
                mergeItems.computeIfAbsent(splitGroup.getBatchNo(), k -> new ArrayList()).addAll(this.sellerBillItemMapper.mapToBillItems(itemVOS));
            }
            for (SplitGroup makeOutVo : outSplitGroupList) {
                long batchNo = makeOutVo.getBatchNo();
                long ruleId = makeOutVo.getRuleId();
                int mergeType = makeOutVo.getMergeType();
                if (set.contains(batchNo)) {
                    throw new IllegalArgumentException("\u6279\u6b21\u53f7" + batchNo + "\u4e0d\u80fd\u5206\u6279\u7ec4\u88c5.");
                }
                set.add(batchNo);
                SplitPreInvoiceRequest splitPreInvoiceRequest = new SplitPreInvoiceRequest();
                splitPreInvoiceRequest.setAutoMakesalesBillIds(Collections.emptyList());
                splitPreInvoiceRequest.setMergeType(mergeType);
                splitPreInvoiceRequest.setSplitType(SplitType.MANUAL.value());
                splitPreInvoiceRequest.setBatchNo(Long.valueOf(batchNo));
                splitPreInvoiceRequest.setOperatorUser(operatorUser);
                splitPreInvoiceRequest.setBillInfo(this.billAdapterService.buildBillInfo(mergeType, batchNo, noneMergeItems, mergeItems, noneMergeBill, mergeBill, null));
                splitPreInvoiceRequest.setSplitRule(this.billAdapterService.buildSplitRule(ruleId, splitPreInvoiceRequest.getBillInfo()));
                splitPreInvoiceRequestList.add(splitPreInvoiceRequest);
            }
            List batchNoList = splitPreInvoiceRequestList.stream().map(SplitPreInvoiceRequest::getBatchNo).collect(Collectors.toList());
            String json = JsonUtils.writeObjectToFastJson(batchNoList);
            if (json.length() > 2000) {
                String random = UUID.randomUUID().toString();
                String filePath = this.billAdapterService.getSalesSplitRequestDataPath() + random;
                try {
                    log.info("\u4e0a\u4f20\u62c6\u7968\u8bf7\u6c42\u5230oss/minio path:{}", (Object)filePath);
                    String key = this.billAdapterService.putFileToOss(json, filePath);
                    log.info("splitPreInvoiceRequestList params batchNo:{},\u751f\u6210\u7684key:{}", (Object)random, (Object)key);
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u62c6\u7968\u8bf7\u6c42\u5230oss/minio\u5f02\u5e38", (Throwable)e);
                }
            } else {
                log.info("splitPreInvoiceRequestList params batchNo:{}", (Object)json);
            }
            splitPreInvoiceResponse = this.billAdapterService.splitAndMakeOut(splitPreInvoiceRequestList);
        }
        catch (Exception e) {
            log.error("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            StringBuilder msgTips = new StringBuilder();
            List collect = outSplitGroupList.stream().map(SplitGroup::getBatchNo).collect(Collectors.toList());
            log.info("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!batchNo:{} \u6267\u884c\u56de\u6eda! ", collect);
            Response response = this.billUpdateApi.afterPreInvDeleteBillStatus(adapterParams.getTenantId(), collect);
            if (response.isOk()) {
                msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!batchNo:%s \u5df2\u7ecf\u56de\u6eda! ", collect));
            } else {
                log.info("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!\u56de\u6eda\u6279\u6b21\u53f7\u5931\u8d25,\u9700\u8981\u4eba\u5de5\u5904\u7406,response:{},batchNo:{}", (Object)response.getMessage(), collect);
                msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!\u56de\u6eda\u6279\u6b21\u53f7\u5931\u8d25,\u9700\u8981\u4eba\u5de5\u5904\u7406.batchNo:%s ", collect));
            }
            makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.Fail);
            makeOutInvoiceResponse.setMessage(msgTips.toString());
            return makeOutInvoiceResponse;
        }
        makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.OK);
        makeOutInvoiceResponse.setMessage("\u5f00\u7968\u6d88\u606f\u5df2\u53d1\u51fa.");
        if (this.billNewMakeOut == 1) {
            AsyncModel asyncModel = this.billAdapterService.createAsyncModel(splitPreInvoiceResponse.getTaskId().longValue());
            makeOutInvoiceResponse.setResult(asyncModel);
        } else {
            makeOutInvoiceResponse.setResult(baseAsyncResponse.getResult());
        }
        log.info("makeOutResponse:" + makeOutInvoiceResponse);
        return makeOutInvoiceResponse;
    }

    public String adapterName() {
        return "processMakeOutInvoice";
    }
}

