/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.TaxCodeModel;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GetCodeModelAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(GetCodeModelAdapter.class);
    @Autowired
    private BillItemClient billItemClient;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Long itemId = (Long)params.get("itemId");
        Response response = this.billItemClient.queryBillItem(tenantId, Arrays.asList(itemId));
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        BillItem billItem = (BillItem)result.get(0);
        TaxCodeModel taxCodeModel = new TaxCodeModel();
        taxCodeModel.setGoodsTaxNo(billItem.getGoodsTaxNo());
        taxCodeModel.setItemName(billItem.getItemName());
        taxCodeModel.setItemShortName(billItem.getItemShortName());
        if (billItem.getTaxRate() != null) {
            taxCodeModel.setTaxRate(billItem.getTaxRate().toString());
        }
        taxCodeModel.setTaxPre(billItem.getTaxPre());
        taxCodeModel.setTaxPreCon(billItem.getTaxPreCon());
        taxCodeModel.setZeroTax(billItem.getZeroTax());
        return taxCodeModel;
    }

    public String adapterName() {
        return "getCodeModel";
    }
}

