/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.save;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillDetailClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.ReceiptBillItemMapper;
import com.xforceplus.adapter.mapstruct.ReceiptBillMainMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.vo.BillConvertItem;
import com.xforceplus.adapter.vo.BillConvertMain;
import com.xforceplus.receipt.vo.BillDetail;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.response.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MakeSalesBillAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(MakeSalesBillAdapter.class);
    @Autowired
    private ReceiptBillMainMapper billMainMapper;
    @Autowired
    private ReceiptBillItemMapper billItemMapper;
    @Autowired
    private BillDetailClient detailClient;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List billConvertMains = JsonUtils.parseList((String)JsonUtils.serialize(params.get("billMains")), BillConvertMain.class);
        List billConvertItems = JsonUtils.parseList((String)JsonUtils.serialize(params.get("billItems")), BillConvertItem.class);
        String groupId = String.valueOf(params.get("groupId"));
        Map headerMap = (Map)params.get("headers");
        Map<Long, List<BillConvertItem>> collect = billConvertItems.stream().collect(Collectors.groupingBy(item -> item.getSalesbillId()));
        List billDetails = billConvertMains.stream().map(billConvertMain -> {
            List<BillItem> billItemList = this.billItemMapper.mapToBillItems((List)collect.get(billConvertMain.getSalesbillId()));
            BillMain billMain = this.billMainMapper.mapToBillMain((BillConvertMain)billConvertMain);
            BillDetail billDetail = new BillDetail();
            billDetail.setItems(billItemList);
            billDetail.setMain(billMain);
            return billDetail;
        }).collect(Collectors.toList());
        Response response = this.detailClient.addBillDetails(tenantId, billDetails);
        HashMap map = Maps.newHashMap();
        if (response.isOk()) {
            map.put("successMains", params.get("billMains"));
            map.put("successItems", params.get("billItems"));
        } else {
            map.put("failSalesBillIds", billConvertMains.stream().map(BillConvertMain::getSalesbillId).collect(Collectors.toList()));
        }
        return map;
    }

    public String adapterName() {
        return "makeSalesBill";
    }
}

