/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.xforceplus.adapter.component.merge.AbstractMergeAdapter;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.ReceiptMergeToolsClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.receipt.vo.request.BillMergeRequest;
import com.xforceplus.receipt.vo.request.MergeToolsRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.BillMergeParser;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillAutoMergeAdapter
extends AbstractMergeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillAutoMergeAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private ReceiptMergeToolsClient receiptMergeToolsClient;
    @Autowired
    private BillMergeParser billMergeParser;

    public Object process(AdapterParams adapterParams) {
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object action = adapterParams.getParams().get("action");
        Map extOutOrdSalesbillDetailVO2CombRuleMap = (Map)paramMap.get("extOutOrdSalesbillDetailVO2CombRuleMap");
        MakeOutInvoiceResponse failResponse = new MakeOutInvoiceResponse().code(Response.Fail);
        List outSplitGroupList = (List)paramMap.get("outSplitGroupList");
        for (Map.Entry ruleEntry : extOutOrdSalesbillDetailVO2CombRuleMap.entrySet()) {
            BillMergerRuleDTO ruleBean;
            MsConfigBean bean = (MsConfigBean)ruleEntry.getValue();
            List itemList = bean.getItemList();
            BillMergerRuleDTO billMergerRuleDTO = ruleBean = this.billMergeParser.parse(itemList);
            log.info("\u7ec4\u5408\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoAssociationFlag());
            log.info("\u5408\u5e76\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoMergeFlag());
            log.debug("MergeRule{}", (Object)billMergerRuleDTO.getMergeRule());
            log.info("RuleId{}", (Object)billMergerRuleDTO.getRuldId());
            List vo = (List)ruleEntry.getKey();
            try {
                Supplier<Object> supplier = Objects.nonNull(action) && Objects.equals("", action) ? () -> {
                    BillMergeRequest request = this.prepareMergeRequest(billMergerRuleDTO, vo);
                    return this.billMainClient.merge(tenantId, request);
                } : () -> {
                    MergeToolsRequest mergeToolsRequest = this.prepareMergeToolsRequest(billMergerRuleDTO, vo);
                    return this.receiptMergeToolsClient.merge(tenantId, mergeToolsRequest);
                };
                this.requestMerge(supplier, outSplitGroupList, billMergerRuleDTO, vo);
                failResponse.setCode(Response.OK);
            }
            catch (Exception e) {
                failResponse.setCode(Response.Fail);
                failResponse.setMessage(e.getMessage());
                return failResponse;
            }
        }
        return null;
    }

    public String adapterName() {
        return "salesBillGroup";
    }
}

