/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.MergeBillItemRequest;
import com.xforceplus.receipt.enums.FunctionFlag;
import com.xforceplus.receipt.vo.MergeConfigParamAssembly;
import com.xforceplus.receipt.vo.request.BillMergeDetail;
import com.xforceplus.receipt.vo.request.BillMergeRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillMergeARService
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillMergeARService.class);
    private static final int SOURCE_BILL_ITEM_MERGE_MIN_NUM = 2;
    private static final int IN_MONEY = 1;
    private static final int OUT_MONEY = 2;
    @Autowired
    private BillMainClient billMainClient;

    public Object process(AdapterParams param) {
        Map params = param.getParams();
        MergeBillItemRequest mergeBillItemRequest = (MergeBillItemRequest)params.get("mergeBillItemRequest");
        Integer quantityPriceResult = mergeBillItemRequest.getQuantityPriceResult();
        ArrayList<MergeConfigParamAssembly> mergeConfigParamAssemblies = new ArrayList<MergeConfigParamAssembly>();
        MergeConfigParamAssembly quantityConfig = new MergeConfigParamAssembly();
        mergeConfigParamAssemblies.add(quantityConfig);
        switch (quantityPriceResult) {
            case 1: {
                quantityConfig.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
                break;
            }
            case 2: {
                quantityConfig.setFunctionName(FunctionFlag.QUANTITY_MERGE_TO_ONE.name());
                break;
            }
            case 3: {
                quantityConfig.setFunctionName(FunctionFlag.KEEP_PRICE.name());
                break;
            }
            case 4: {
                quantityConfig.setFunctionName(FunctionFlag.NO_QUANTITY_NO_PRICE.name());
                break;
            }
            default: {
                log.info("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:[{}]", (Object)quantityPriceResult);
                return Response.failed((String)("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:" + quantityPriceResult));
            }
        }
        MergeConfigParamAssembly negativeDiscountConfig = new MergeConfigParamAssembly();
        if (null == mergeBillItemRequest.getNegativeDiscountRule()) {
            negativeDiscountConfig.setFunctionName(FunctionFlag.NEGATIVE_TO_INNER_DISCOUNT.name());
        } else {
            negativeDiscountConfig.setFunctionName(FunctionFlag.NEGATIVE_TO_OUTER_DISCOUNT.name());
        }
        mergeConfigParamAssemblies.add(negativeDiscountConfig);
        BillMergeRequest request = new BillMergeRequest();
        request.setItemId(mergeBillItemRequest.getSelectId());
        ArrayList<BillMergeDetail> billMergeDetails = new ArrayList<BillMergeDetail>();
        billMergeDetails.add(new BillMergeDetail(null, mergeBillItemRequest.getSalesbillItemIdList()));
        request.setBills(billMergeDetails);
        request.setCombineConfigs(Collections.emptyList());
        request.setMergeConfigs(mergeConfigParamAssemblies);
        com.xforceplus.receipt.vo.response.Response response = this.billMainClient.merge(param.getTenantId(), request);
        if (response.isOk()) {
            return Response.ok((String)"\u5408\u5e76\u6210\u529f!");
        }
        return Response.failed((String)response.getMessage());
    }

    public String adapterName() {
        return "mergeBillItemAR";
    }
}

