/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillItemMapByIdsQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillItemMapByIdsQueryAdapter.class);
    @Autowired
    private BillItemClient billItemClient;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List billItemIds = (List)params.get("billItemIdList");
        Response response = this.billItemClient.queryBillItem(tenantId, billItemIds);
        List result = (List)response.getResult();
        Map map = result.stream().collect(Collectors.groupingBy(BillItem::getBillId, Collectors.mapping(BillItem::getId, Collectors.toList())));
        return map;
    }

    public String adapterName() {
        return "getBillItemListMap";
    }
}

