/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillSourceClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.SourceBillNoRequest;
import com.xforceplus.phoenix.bill.client.model.SourceBillNoResponse;
import com.xforceplus.receipt.vo.BillSource;
import com.xforceplus.receipt.vo.request.BillSourceRelQueryRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillOriginNoQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillOriginNoQueryAdapter.class);
    @Autowired
    private BillSourceClient billSourceClient;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        SourceBillNoRequest request = (SourceBillNoRequest)params.get("sourceBillNoRequest");
        String billId = request.getSalesbillId();
        BillSourceRelQueryRequest queryRequest = new BillSourceRelQueryRequest();
        queryRequest.setTargetBillIds(Collections.singletonList(Long.valueOf(billId)));
        com.xforceplus.receipt.vo.response.Response response = this.billSourceClient.queryBillSource(tenantId, queryRequest);
        List result = (List)response.getResult();
        SourceBillNoResponse sourceBillNoResponse = new SourceBillNoResponse();
        sourceBillNoResponse.setCode(Response.OK);
        if (CollectionUtils.isEmpty((Collection)result)) {
            sourceBillNoResponse.setResult(Arrays.asList(request.getBillNo()));
            return sourceBillNoResponse;
        }
        sourceBillNoResponse.setResult(result.stream().map(BillSource::getBillNo).distinct().collect(Collectors.toList()));
        return sourceBillNoResponse;
    }

    public String adapterName() {
        return "querySourceBillNo";
    }
}

