/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.UserRole;
import com.xforceplus.phoenix.esutils.EsPageQueryUtils;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.enums.FieldSource;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.request.BillAbandonRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillAbandonAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillAbandonAdapter.class);
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private BillOperationAdapterService operationAdapterService;
    @Autowired
    private BillAdapterService adapterService;
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Value(value="${authorization.group.ids:}")
    private String authorizationGroupIds;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillRequest request = (BillRequest)params.get("billRequest");
        String role = String.valueOf(params.get("role"));
        Boolean confirmFlag = request.getConfirmFlag();
        BillSearchModel billSearchModel = BillAbandonAdapter.getSearchCondition(request, role);
        this.operationAdapterService.buildModelAuthority(billSearchModel);
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        SearchModel searchModel = this.adapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListOptimizeAdapter.mappingMainSortField(searchModel.getSort());
        }
        BillAbandonRequest abandonRequest = new BillAbandonRequest();
        abandonRequest.setSearchModel(this.searchModelMapper.mapToAbandonSearchModel(searchModel));
        abandonRequest.setUserInfo(userInfo);
        if (!confirmFlag.booleanValue()) {
            Response response = this.updateClient.abandonBillCheck(tenantId, abandonRequest);
            if (response.isOk()) {
                return com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage(), (Object)response.getResult());
            }
            return com.xforceplus.xplatframework.model.Response.failed((String)response.getMessage());
        }
        Response response = this.updateClient.abandonBill(tenantId, abandonRequest);
        return response.isOk() ? com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage()) : com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage(), (Object)response.getResult());
    }

    public String adapterName() {
        return "abandonBill";
    }

    public static BillSearchModel getSearchCondition(BillRequest billRequest, String role) {
        if (null == billRequest || null == billRequest.getConditions()) {
            return null;
        }
        BillSearchModel billSearchModel = billRequest.getConditions();
        billSearchModel.setUserRole(BusinessBillType.AR.value().equals(role) ? UserRole.SELLER.value() : UserRole.PURCHASER.value());
        ArrayList searchFilters = Lists.newArrayList();
        SearchFilter searchFilter = null;
        if (!billRequest.getIsAllSelected().booleanValue()) {
            List includes = billRequest.getIncludes();
            if (!CollectionUtils.isEmpty((Collection)includes)) {
                searchFilter = new SearchFilter();
                searchFilter.setFieldName("id");
                searchFilter.setValue(includes);
                searchFilter.setFieldQueryType(Operator.checkbox);
                searchFilter.setVirtual(FieldSource.main.value());
                searchFilter.setFieldGroupIndex(Integer.valueOf(0));
            }
        } else {
            List excludes = billRequest.getExcludes();
            if (!CollectionUtils.isEmpty((Collection)excludes)) {
                searchFilter = new SearchFilter();
                searchFilter.setFieldName("id");
                searchFilter.setValue(excludes);
                searchFilter.setFieldQueryType(Operator.not_in);
                searchFilter.setVirtual(FieldSource.main.value());
                searchFilter.setFieldGroupIndex(Integer.valueOf(0));
            }
        }
        if (searchFilter != null) {
            searchFilters.add(searchFilter);
        }
        List groups = EsPageQueryUtils.mergeGroups((List)billSearchModel.getGroups(), Arrays.asList(searchFilters));
        if (!CollectionUtils.isEmpty((Collection)billSearchModel.getSysOrgIdList())) {
            SearchFilter sysOrgIdFilter = new SearchFilter("sysOrgId", billSearchModel.getSysOrgIdList(), Operator.checkbox);
            sysOrgIdFilter.setClazz(Integer.class);
            ArrayList authGroup = Lists.newArrayList();
            authGroup.add(sysOrgIdFilter);
            List finalgroups = EsPageQueryUtils.mergeGroups((List)groups, Arrays.asList(authGroup));
            billSearchModel.setGroups(finalgroups);
        } else {
            billSearchModel.setGroups(groups);
        }
        return billSearchModel;
    }
}

