/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillDetailClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillItemMapper;
import com.xforceplus.adapter.mapstruct.InvoiceBillMainMapper;
import com.xforceplus.phoenix.bill.client.model.BillQueryResponse;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillItem;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMain;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillMainListByBatchNoAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillMainListByBatchNoAdapter.class);
    @Autowired
    private BillDetailClient billDetailClient;
    @Autowired
    private InvoiceBillMainMapper invoiceBillMainMapper;
    @Autowired
    private InvoiceBillItemMapper invoiceBillItemMapper;

    public Object process(AdapterParams adapterParams) {
        Object batchNo;
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Response response = this.billDetailClient.queryBillDetailByBatchNo(tenantId, Long.valueOf((batchNo = paramMap.get("batchNo")).toString()));
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return BillQueryResponse.fail((String)CommonTools.format((String)"\u6839\u636e\u6279\u6b21\u53f7{}\u672a\u67e5\u8be2\u5230", (Object[])new Object[]{batchNo}));
        }
        List collect = result.stream().map(billDetail -> {
            BillMain main = billDetail.getMain();
            List items = billDetail.getItems();
            InvoiceBillMain invoiceBillMain = this.invoiceBillMainMapper.mapToInvoiceBillMain(main);
            List<InvoiceBillItem> invoiceBillItems = this.invoiceBillItemMapper.mapToInvoiceBillItems(items);
            invoiceBillMain.setBillItems(invoiceBillItems);
            return invoiceBillMain;
        }).collect(Collectors.toList());
        BillQueryResponse billQueryResponse = new BillQueryResponse();
        billQueryResponse.setCode(BaseResponse.OK);
        billQueryResponse.setResult(collect);
        return billQueryResponse;
    }

    public String adapterName() {
        return "mainListByBatchNo";
    }
}

