/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.ReceiptSearchSortMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillGetBillListOptimizeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillGetBillListOptimizeAdapter.class);
    @Autowired
    private BillEsSearchClient esSearchClient;
    @Autowired
    private OrdSalesbillVoMapper billVoMapper;
    @Autowired
    private SearchModelMapper searchModelMapper;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        BillSearchModel billSearchModel = (BillSearchModel)params.get("billSearchModel");
        SearchModel searchModel = (SearchModel)params.get("searchModel");
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListOptimizeAdapter.mappingMainSortField(searchModel.getSort());
        }
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setRequestSource(Integer.valueOf(billSearchModel.getRequestSource()));
        request.setSearchModel(this.searchModelMapper.mapToSearchRequest(searchModel));
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        request.getSearchModel().setSearchSort(searchSort);
        try {
            Response resPageListResponse = this.esSearchClient.billMainElasticSearch(tenantId, request);
            ResPageList result = (ResPageList)resPageListResponse.getResult();
            ResPageList pageList = new ResPageList();
            pageList.setTotalDetailsCount(result.getTotalDetailsCount());
            pageList.setTotalBillCount(result.getTotalBillCount());
            pageList.setTotal(result.getTotal());
            pageList.setTotalAmountWithTax(result.getTotalAmountWithTax());
            pageList.setTotalAmountWithoutTax(result.getTotalAmountWithoutTax());
            List<OrdSalesbillVO> ordSalesbillVOS = this.billVoMapper.mapToBillVos(result.getList());
            pageList.setList(ordSalesbillVOS);
            return BillResponse.from((Integer)com.xforceplus.xplatframework.model.Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)pageList);
        }
        catch (Exception e) {
            return BillResponse.from((Integer)com.xforceplus.xplatframework.model.Response.Fail, (String)e.getMessage());
        }
    }

    public static void mappingMainSortField(SearchSort sort) {
        sort.setFieldName(MainMapping.getField((String)sort.getFieldName()));
        if (!CollectionUtils.isEmpty((Collection)sort.getSearchSort())) {
            for (SearchSort searchSort : sort.getSearchSort()) {
                BillGetBillListOptimizeAdapter.mappingMainSortField(searchSort);
            }
        }
        if (Objects.nonNull(sort.getMainSort())) {
            SearchSort mainSort = sort.getMainSort();
            mainSort.setFieldName(MainMapping.getField((String)sort.getFieldName()));
        }
    }

    public static ReceiptSearchSort initSearchSorts(SearchSort sort) {
        if (Objects.isNull(sort)) {
            return null;
        }
        ReceiptSearchSortMapper mapper = (ReceiptSearchSortMapper)Mappers.getMapper(ReceiptSearchSortMapper.class);
        ReceiptSearchSort receiptSearchSort = mapper.mapTo(sort);
        SearchSort mainSort = sort.getMainSort();
        receiptSearchSort.setMainSort(mapper.mapTo(mainSort));
        List searchSort = sort.getSearchSort();
        if (!CollectionUtils.isEmpty((Collection)searchSort)) {
            List collect = searchSort.stream().map(s -> BillGetBillListOptimizeAdapter.initSearchSorts(s)).collect(Collectors.toList());
            receiptSearchSort.setSearchSort(collect);
        }
        return receiptSearchSort;
    }

    public String adapterName() {
        return "getBillListOptimize";
    }
}

