/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.component.query.BillGetBillListByDetailOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.enums.AggregationTypeEnum;
import com.xforceplus.receipt.vo.BillItemAggResult;
import com.xforceplus.receipt.vo.request.AggregationCondition;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetRecommendedItemIdsAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(GetRecommendedItemIdsAdapter.class);
    @Autowired
    private BillEsSearchClient searchClient;
    @Autowired
    private SearchModelMapper searchModelMapper;

    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        SearchModel searchModel = (SearchModel)params.get("billSearch");
        Integer taxCodeRecommendedMaxSize = (Integer)params.get("taxCodeRecommendedMaxSize");
        searchModel.setPageSize(taxCodeRecommendedMaxSize);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListByDetailOptimizeAdapter.mappingItemSortField(searchModel.getSort());
        }
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        AggregationCondition itemName = new AggregationCondition();
        itemName.setAggregationTypeEnum(AggregationTypeEnum.cardinality);
        itemName.setKey("itemName");
        itemName.setFiled("itemName");
        AggregationCondition rateName = new AggregationCondition();
        rateName.setAggregationTypeEnum(AggregationTypeEnum.cardinality);
        rateName.setKey("taxRate");
        rateName.setFiled("taxRate");
        searchRequest.setIncludes(Arrays.asList("id"));
        searchRequest.setAggregationConditions(Arrays.asList(itemName, rateName));
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        request.setSearchModel(searchRequest);
        Response responseResponse = this.searchClient.billItemAggElasticsearch(tenantId, request);
        BillItemAggResult result = (BillItemAggResult)responseResponse.getResult();
        Map aggregations = result.getAggregations();
        if (null != aggregations) {
            ParsedCardinality aggregation;
            if (null != aggregations.get("itemName") && null != (aggregation = (ParsedCardinality)JsonUtils.parse((String)JsonUtils.serialize(aggregations.get("itemName")), ParsedCardinality.class)) && aggregation.getValue() > 1L) {
                return com.xforceplus.xplatframework.model.Response.from((Integer)com.xforceplus.xplatframework.model.Response.Fail, (String)"\u4ec5\u53ef\u4ee5\u9488\u5bf9\u76f8\u540c\u5546\u54c1\u7684\u660e\u7ec6\u63a8\u8350\u7a0e\u7f16");
            }
            if (null != aggregations.get("taxRate") && null != (aggregation = (ParsedCardinality)JsonUtils.parse((String)JsonUtils.serialize(aggregations.get("taxRate")), ParsedCardinality.class)) && aggregation.getValue() > 1L) {
                return com.xforceplus.xplatframework.model.Response.from((Integer)com.xforceplus.xplatframework.model.Response.Fail, (String)"\u4ec5\u53ef\u4ee5\u9488\u5bf9\u76f8\u540c\u7a0e\u7387\u7684\u660e\u7ec6\u63a8\u8350\u7a0e\u7f16");
            }
        }
        List itemIds = result.getDatas().stream().map(e -> String.valueOf(e.get("id"))).collect(Collectors.toList());
        HashMap map = Maps.newHashMap();
        map.put("itemIds", itemIds);
        map.put("total", result.getTotal());
        return com.xforceplus.xplatframework.model.Response.ok((String)"\u6821\u9a8c\u6210\u529f", (Object)map);
    }

    public String adapterName() {
        return "getRecommendedItemIds";
    }
}

