/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.adapter.vo.AbandonVoExt;
import com.xforceplus.adapter.vo.CheckPreInvoicesBeforeDelAndNoDelete;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.UserRole;
import com.xforceplus.phoenix.esutils.EsPageQueryUtils;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.enums.FieldSource;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.AbandonVo;
import com.xforceplus.receipt.vo.BillCheckResult;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.UserInfo;
import com.xforceplus.receipt.vo.request.BillAbandonCheckRequest;
import com.xforceplus.receipt.vo.request.BillAbandonRequest;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillAbandonAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillAbandonAdapter.class);
    @Autowired
    private UserInfoHolder<com.xforceplus.xplatframework.apimodel.UserInfo> userInfoHolder;
    @Autowired
    private BillOperationAdapterService operationAdapterService;
    @Autowired
    private BillAdapterService adapterService;
    @Autowired
    private BillItemClient itemClient;
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Value(value="${authorization.group.ids:}")
    private String authorizationGroupIds;
    private static final String SUCESS_COUNT = "sucess";
    private static final String FAIL_COUNT = "fail";

    public Object process(AdapterParams adapterParams) {
        Set successId;
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        BillRequest request = (BillRequest)params.get("billRequest");
        String role = String.valueOf(params.get("role"));
        Boolean confirmFlag = request.getConfirmFlag();
        BillSearchModel billSearchModel = BillAbandonAdapter.getSearchCondition(request, role);
        this.operationAdapterService.buildModelAuthority(billSearchModel);
        com.xforceplus.xplatframework.apimodel.UserInfo info = (com.xforceplus.xplatframework.apimodel.UserInfo)this.userInfoHolder.get();
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        SearchModel searchModel = this.adapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        if (Objects.nonNull(searchModel.getSort())) {
            BillGetBillListOptimizeAdapter.mappingMainSortField(searchModel.getSort());
        }
        BillAbandonCheckRequest abandonCheckRequest = new BillAbandonCheckRequest();
        abandonCheckRequest.setSearchModel(this.searchModelMapper.mapToAbandonSearchModel(searchModel));
        Response checkResponse = this.updateClient.abandonBillCheck(tenantId, abandonCheckRequest);
        AbandonVoExt abandonVoExt = null;
        if (checkResponse.isOk() && !(successId = ((AbandonVo)checkResponse.getResult()).getSuccessId()).isEmpty()) {
            ArrayList list = new ArrayList(successId);
            com.xforceplus.xplatframework.model.Response r = this.adapterService.abandonOrDelPreInvoice(confirmFlag, list);
            log.info("\u6821\u9a8c\u9884\u5236\u53d1\u7968\u8fd4\u56de:{}", (Object)JsonUtils.writeObjectToJson((Object)r));
            if (!com.xforceplus.xplatframework.model.Response.OK.equals(r.getCode())) {
                return r;
            }
            List<BillCheckResult> results = ((AbandonVo)checkResponse.getResult()).getCheckResults();
            if (!CollectionUtils.isEmpty((Collection)((AbandonVo)checkResponse.getResult()).getCheckResults())) {
                List<Long> failIds;
                CheckPreInvoicesBeforeDelAndNoDelete checkPreResult;
                Map<Long, String> billNoMap = ((AbandonVo)checkResponse.getResult()).getCheckResults().stream().filter(BillAbandonAdapter.distinctByKey(BillCheckResult::getBillId)).collect(Collectors.toMap(BillCheckResult::getBillId, BillCheckResult::getBillNo));
                ArrayList preCheckFail = Lists.newArrayList();
                ArrayList failBillNos = Lists.newArrayList();
                if (r.getResult() != null && (checkPreResult = (CheckPreInvoicesBeforeDelAndNoDelete)JsonUtils.writeFastJsonToObject((String)JsonUtils.writeObjectToJson((Object)r.getResult()), CheckPreInvoicesBeforeDelAndNoDelete.class)) != null && !CollectionUtils.isEmpty(failIds = checkPreResult.getNoDeleteBillIds())) {
                    failIds.stream().forEach(billId -> {
                        String billNO = (String)billNoMap.get(billId);
                        BillCheckResult billAbandon = new BillCheckResult();
                        billAbandon.setStatus(Integer.valueOf(0));
                        billAbandon.setMsg("\u5df2\u5b58\u5728\u7533\u8bf7\u4e2d\u6216\u5df2\u7533\u8bf7\u7684\u7ea2\u5b57\u4fe1\u606f \u6216\u8005 \u9884\u5236\u53d1\u7968\u5728\u5f00\u7968\u4e2d\u548c\u62c6\u7968\u53d8\u66f4\u4e2d");
                        billAbandon.setBillNo(billNO);
                        preCheckFail.add(billAbandon);
                        failBillNos.add(billNO);
                    });
                    results = results.stream().filter(item -> !failBillNos.contains(item.getBillNo())).collect(Collectors.toList());
                    results.addAll(preCheckFail);
                    AbandonVo result = (AbandonVo)checkResponse.getResult();
                    abandonVoExt = new AbandonVoExt();
                    abandonVoExt.setBillAbandonReasons(results);
                    abandonVoExt.setFail(result.getFail() + failBillNos.size());
                    abandonVoExt.setSuccess(result.getSuccess() - failBillNos.size());
                    abandonVoExt.getSuccessId().removeAll(failIds);
                    ((AbandonVo)checkResponse.getResult()).setSuccessId(abandonVoExt.getSuccessId());
                }
            }
        }
        if (!confirmFlag.booleanValue()) {
            if (checkResponse.isOk()) {
                if (abandonVoExt == null) {
                    abandonVoExt = new AbandonVoExt();
                    abandonVoExt.setSuccess(((AbandonVo)checkResponse.getResult()).getSuccess());
                    abandonVoExt.setFail(((AbandonVo)checkResponse.getResult()).getFail());
                    abandonVoExt.setBillAbandonReasons(((AbandonVo)checkResponse.getResult()).getCheckResults());
                }
                return com.xforceplus.xplatframework.model.Response.ok((String)checkResponse.getMessage(), (Object)abandonVoExt);
            }
            return com.xforceplus.xplatframework.model.Response.failed((String)checkResponse.getMessage());
        }
        AbandonVo result = (AbandonVo)checkResponse.getResult();
        Set successId2 = result.getSuccessId();
        if (CollectionUtils.isEmpty((Collection)successId2)) {
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u65e0\u53ef\u4f5c\u5e9f\u7684\u4e1a\u52a1\u5355!");
        }
        ArrayList list = new ArrayList(successId2);
        BillMainQueryRequest queryRequest = new BillMainQueryRequest();
        queryRequest.setBillIds(list);
        Response bills = this.mainClient.queryBills(tenantId, queryRequest);
        List billMains = (List)bills.getResult();
        Response items = this.itemClient.queryBillItemByBillId(tenantId, list);
        List billItems = (List)items.getResult();
        Set batchNos = billItems.stream().filter(i -> i.getBatchNo() != 0L).map(i -> i.getBatchNo()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(batchNos)) {
            com.xforceplus.xplatframework.model.Response response = this.operationAdapterService.delPreInvoiceByBatchNos(new ArrayList(batchNos));
            log.info("\u4f5c\u5e9f\u9884\u5236\u53d1\u7968");
            if (com.xforceplus.xplatframework.model.Response.Fail.equals(response.getCode())) {
                return com.xforceplus.xplatframework.model.Response.failed((String)"\u9884\u5236\u53d1\u7968\u5220\u9664\u5931\u8d25,\u65e0\u7ee7\u7eed\u4f5c\u5e9f!");
            }
        }
        BillAbandonRequest abandonRequest = new BillAbandonRequest();
        abandonRequest.setUserInfo(userInfo);
        abandonRequest.setBillIds(list);
        log.info("\u4f5c\u5e9f\u4e1a\u52a1\u5355");
        Response response = this.updateClient.abandonBill(tenantId, abandonRequest);
        boolean ok = response.isOk();
        if (ok) {
            Map<Long, List<BillItem>> collect = billItems.stream().collect(Collectors.groupingBy(i -> i.getBillId()));
            for (BillMain billMain : billMains) {
                HashMap sendMap = Maps.newHashMap();
                ArrayList mainMaps = Lists.newArrayList();
                ArrayList itemMaps = Lists.newArrayList();
                HashMap mainMap = Maps.newHashMap();
                mainMap.put("salesbillNo", billMain.getBillNo());
                mainMap.put("processRemark", "\u4f5c\u5e9f\u6210\u529f");
                mainMaps.add(mainMap);
                List<BillItem> itemList = collect.get(billMain.getId());
                itemList.stream().forEach(m -> {
                    HashMap itemMap = Maps.newHashMap();
                    itemMap.put("salesbillItemNo", m.getItemNo());
                    itemMap.put("processRemark", "");
                    itemMaps.add(itemMap);
                });
                sendMap.put("main", mainMaps);
                sendMap.put("items", itemMaps);
                String remark = JsonUtils.writeObjectToFastJson((Object)sendMap);
                log.info("adapter\u4e0b\u53d1\u4e1a\u52a1\u5355");
                this.operationAdapterService.sendBillMessage(remark, this.headers(info, billMain, request.getDesc()), Integer.valueOf(1));
            }
        }
        return ok ? com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage()) : com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage(), (Object)response.getResult());
    }

    public String adapterName() {
        return "abandonBill";
    }

    private Map headers(com.xforceplus.xplatframework.apimodel.UserInfo userInfo, BillMain main, String abandonRemark) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("systemOrig", main.getSystemOrig());
        headers.put("status", main.getStatus().toString());
        if (!CollectionUtils.isEmpty((Map)main.getExtendJson()) && main.getExtendJson().get("customerNo") != null) {
            headers.put("customNo", main.getExtendJson().get("customerNo"));
        }
        headers.put("groupId", userInfo.getGroupId());
        headers.put("orgId", userInfo.getOrgId());
        headers.put("orgCode", userInfo.getOrgCode());
        headers.put("userId", userInfo.getUserId());
        headers.put("userName", userInfo.getUserName());
        headers.put("mobile", userInfo.getMobile());
        headers.put("businessBillType", main.getBusinessBillType());
        headers.put("abandonRemark", abandonRemark);
        headers.put("businessNo", main.getBillNo());
        headers.put("sellerTaxNo", main.getSellerTaxNo());
        headers.put("purchaserTaxNo", main.getPurchaserTaxNo());
        return headers;
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static BillSearchModel getSearchCondition(BillRequest billRequest, String role) {
        if (null == billRequest || null == billRequest.getConditions()) {
            return null;
        }
        BillSearchModel billSearchModel = billRequest.getConditions();
        billSearchModel.setUserRole(BusinessBillType.AR.value().equals(role) ? UserRole.SELLER.value() : UserRole.PURCHASER.value());
        ArrayList searchFilters = Lists.newArrayList();
        SearchFilter searchFilter = null;
        if (!billRequest.getIsAllSelected().booleanValue()) {
            List includes = billRequest.getIncludes();
            if (!CollectionUtils.isEmpty((Collection)includes)) {
                searchFilter = new SearchFilter();
                searchFilter.setFieldName("id");
                searchFilter.setValue(includes);
                searchFilter.setFieldQueryType(Operator.checkbox);
                searchFilter.setVirtual(FieldSource.main.value());
                searchFilter.setFieldGroupIndex(Integer.valueOf(0));
            }
        } else {
            List excludes = billRequest.getExcludes();
            if (!CollectionUtils.isEmpty((Collection)excludes)) {
                searchFilter = new SearchFilter();
                searchFilter.setFieldName("id");
                searchFilter.setValue(excludes);
                searchFilter.setFieldQueryType(Operator.not_in);
                searchFilter.setVirtual(FieldSource.main.value());
                searchFilter.setFieldGroupIndex(Integer.valueOf(0));
            }
        }
        if (searchFilter != null) {
            searchFilters.add(searchFilter);
        }
        List groups = EsPageQueryUtils.mergeGroups((List)billSearchModel.getGroups(), Arrays.asList(searchFilters));
        if (!CollectionUtils.isEmpty((Collection)billSearchModel.getSysOrgIdList())) {
            SearchFilter sysOrgIdFilter = new SearchFilter("sysOrgId", billSearchModel.getSysOrgIdList(), Operator.checkbox);
            sysOrgIdFilter.setClazz(Integer.class);
            ArrayList authGroup = Lists.newArrayList();
            authGroup.add(sysOrgIdFilter);
            List finalgroups = EsPageQueryUtils.mergeGroups((List)groups, Arrays.asList(authGroup));
            billSearchModel.setGroups(finalgroups);
        } else {
            billSearchModel.setGroups(groups);
        }
        return billSearchModel;
    }
}

