/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.model.ItemMapping;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.SplitGroup;
import com.xforceplus.phoenix.bill.client.enums.BillMergeType;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.receipt.dto.config.CombinationField;
import com.xforceplus.receipt.dto.config.SourceDto;
import com.xforceplus.receipt.enums.FunctionFlag;
import com.xforceplus.receipt.vo.BillDetail;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.CombineConfigParamAssembly;
import com.xforceplus.receipt.vo.MergeConfigParamAssembly;
import com.xforceplus.receipt.vo.MergeRelationVo;
import com.xforceplus.receipt.vo.request.BillMergeDetail;
import com.xforceplus.receipt.vo.request.BillMergeRequest;
import com.xforceplus.receipt.vo.request.MergeToolsRequest;
import com.xforceplus.receipt.vo.response.MergeResponse;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.seller.config.client.constant.MergeRuleEnum;
import com.xforceplus.seller.config.client.constant.NagertiveRuleEnum;
import com.xforceplus.seller.config.client.constant.SecondMergeRuleEnum;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractMergeAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMergeAdapter.class);
    @Autowired
    private BillAdapterService billAdapterService;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;
    @Autowired
    private OrdSalesbillItemVoMapper ordSalesbillItemVoMapper;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Value(value="#{'${jieshibang.merge.tenantId:\"\"}'.split(',')}")
    private List<String> jieshibangMergeIds;
    @Value(value="#{'${xufuji.merge.tenantId:\"\"}'.split(',')}")
    private List<String> xufujiMergeIds;

    public static String getInvoiceType(OrdSalesbillDetailVO ordSalesbillDetailVO) {
        OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
        OrdSalesbillItemVO ordSalesbillItemVO = ordSalesbillDetailVO.getOrdSalesbillItemVO();
        String invoiceType = StringUtils.isBlank((CharSequence)ordSalesbillItemVO.getInvoiceType()) ? ordSalesbillVO.getInvoiceType() : ordSalesbillItemVO.getInvoiceType();
        return invoiceType;
    }

    protected List<MergeConfigParamAssembly> parseMergeConfig(BillMergerRuleDTO billMergerRuleDTO) {
        ArrayList<MergeConfigParamAssembly> mergeConfigParamAssemblies = new ArrayList<MergeConfigParamAssembly>();
        if (billMergerRuleDTO.getAutoMergeFlag().booleanValue()) {
            MergeConfigParamAssembly mergeConfig = new MergeConfigParamAssembly();
            List mergeConditions = billMergerRuleDTO.getMergerCondition().stream().map(x -> {
                CombinationField combinationField = new CombinationField();
                switch (x.getFieldGroupIndex()) {
                    case 0: {
                        combinationField.setField(MainMapping.getField((String)x.getField()));
                        combinationField.setType(CombinationField.FieldType.MAIN);
                        break;
                    }
                    case 1: {
                        combinationField.setField(ItemMapping.getField((String)x.getField()));
                        combinationField.setType(CombinationField.FieldType.ITEM);
                        break;
                    }
                    default: {
                        log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                        throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                    }
                }
                return combinationField;
            }).collect(Collectors.toList());
            mergeConfig.setConditions(mergeConditions);
            MergeRuleEnum mergeRule = billMergerRuleDTO.getMergeRule();
            switch (mergeRule) {
                case quantity_add: {
                    mergeConfig.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
                    break;
                }
                case quantity_merge_To_One: {
                    mergeConfig.setFunctionName(FunctionFlag.QUANTITY_MERGE_TO_ONE.name());
                    break;
                }
                case no_quantity_no_Price: {
                    mergeConfig.setFunctionName(FunctionFlag.NO_QUANTITY_NO_PRICE.name());
                    break;
                }
                case save_price: {
                    mergeConfig.setFunctionName(FunctionFlag.KEEP_PRICE.name());
                    break;
                }
                default: {
                    log.info("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:[{}]", (Object)mergeRule);
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:" + mergeRule);
                }
            }
            mergeConfigParamAssemblies.add(mergeConfig);
            Integer negativeRule = billMergerRuleDTO.getNagertiveRule().getvalue();
            if (Objects.nonNull(negativeRule) && negativeRule == 2) {
                MergeConfigParamAssembly negativeDiscountConfig = new MergeConfigParamAssembly();
                negativeDiscountConfig.setFunctionName(FunctionFlag.NEGATIVE_TO_OUTER_DISCOUNT.name());
                mergeConfigParamAssemblies.add(negativeDiscountConfig);
            } else {
                mergeConfig.setParams(JSON.toJSONString(Collections.singletonMap("negativeRule", 0)));
            }
            if (!Objects.equals(NagertiveRuleEnum.positive_negative_not_merge, billMergerRuleDTO.getNagertiveRule()) && billMergerRuleDTO.getSecondMergeFlag().booleanValue()) {
                MergeConfigParamAssembly assemblyTwo = new MergeConfigParamAssembly();
                MergeRuleEnum secondMergeRule = billMergerRuleDTO.getSecondMergeRule();
                switch (secondMergeRule) {
                    case quantity_add: {
                        assemblyTwo.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
                        break;
                    }
                    case quantity_merge_To_One: {
                        assemblyTwo.setFunctionName(FunctionFlag.QUANTITY_MERGE_TO_ONE.name());
                        break;
                    }
                    case no_quantity_no_Price: {
                        assemblyTwo.setFunctionName(FunctionFlag.NO_QUANTITY_NO_PRICE.name());
                        break;
                    }
                    case save_price: {
                        assemblyTwo.setFunctionName(FunctionFlag.KEEP_PRICE.name());
                        break;
                    }
                    default: {
                        log.info("\u4e8c\u6b21\u5408\u5e76\u4e0d\u652f\u6301\u7684\u5408\u5e76\u89c4\u5219:[{}]", (Object)secondMergeRule);
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u4e8c\u6b21\u5408\u5e76\u89c4\u5219:" + secondMergeRule);
                    }
                }
                List secondCondition = billMergerRuleDTO.getSecondMergeCondition().stream().map(x -> {
                    CombinationField combinationField = new CombinationField();
                    switch (x.getFieldGroupIndex()) {
                        case 0: {
                            combinationField.setType(CombinationField.FieldType.MAIN);
                            combinationField.setField(MainMapping.getField((String)x.getField()));
                            break;
                        }
                        case 1: {
                            combinationField.setType(CombinationField.FieldType.ITEM);
                            combinationField.setField(ItemMapping.getField((String)x.getField()));
                            break;
                        }
                        default: {
                            log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                            throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                        }
                    }
                    return combinationField;
                }).collect(Collectors.toList());
                assemblyTwo.setConditions(secondCondition);
                SecondMergeRuleEnum secondNagertiveRule = billMergerRuleDTO.getSecondNagertiveRule();
                if (secondNagertiveRule == null) {
                    throw new IllegalArgumentException("\u7b2c\u4e8c\u6b21\u5408\u5e76\u6761\u4ef6\u5408\u5e76\u7ed3\u679c\u662f\u5426\u5141\u8bb8\u6b63\u8d1f\u4e3a\u7a7a");
                }
                HashMap<String, Integer> forbidNegative = new HashMap<String, Integer>();
                forbidNegative.put("negativeRule", 0);
                switch (secondNagertiveRule) {
                    case SECOND_MERGE_RESULT_NEGATIVE: {
                        forbidNegative.put("forbidNegative", 0);
                        break;
                    }
                    case SECOND_MERGE_RESULT_NO_NEGATIVE: {
                        forbidNegative.put("forbidNegative", 1);
                        break;
                    }
                    default: {
                        log.info("\u4e8c\u6b21\u5408\u5e76\u7684\u6b63\u8d1f\u5408\u5e76\u89c4\u5219\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u5141\u8bb8\u4e3a\u8d1f");
                    }
                }
                assemblyTwo.setParams(JSON.toJSONString(forbidNegative));
                mergeConfigParamAssemblies.add(assemblyTwo);
            }
        } else {
            MergeConfigParamAssembly mergeConfig = new MergeConfigParamAssembly();
            CombinationField combinationField = new CombinationField();
            combinationField.setField("id");
            combinationField.setType(CombinationField.FieldType.ITEM);
            mergeConfig.setConditions(Collections.singletonList(combinationField));
            mergeConfig.setFunctionName(FunctionFlag.QUANTITY_ADD.name());
            mergeConfigParamAssemblies.add(mergeConfig);
        }
        return mergeConfigParamAssemblies;
    }

    protected List<CombineConfigParamAssembly> parseCombineConfig(BillMergerRuleDTO billMergerRuleDTO, String tenantId) {
        ArrayList<CombineConfigParamAssembly> combineConfigs = new ArrayList<CombineConfigParamAssembly>();
        if (Objects.equals("true", billMergerRuleDTO.getAutoAssociationFlag())) {
            List combinationFields = null;
            if (CollectionUtils.isNotEmpty((Collection)billMergerRuleDTO.getAssociationCondition())) {
                combinationFields = billMergerRuleDTO.getAssociationCondition().stream().map(x -> {
                    if (x.getFieldGroupIndex() == null) {
                        log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex\u4e0d\u80fd\u4e3a\u7a7a");
                        throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    CombinationField combinationField = new CombinationField();
                    switch (x.getFieldGroupIndex()) {
                        case 0: {
                            combinationField.setField(MainMapping.getField((String)x.getField()));
                            combinationField.setType(CombinationField.FieldType.MAIN);
                            break;
                        }
                        case 1: {
                            combinationField.setField(ItemMapping.getField((String)x.getField()));
                            combinationField.setType(CombinationField.FieldType.ITEM);
                            break;
                        }
                        default: {
                            log.info("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[{}],\u4e0d\u5408\u6cd5", (Object)x.getFieldGroupIndex());
                            throw new IllegalArgumentException("\u7ec4\u5408\u6761\u4ef6fieldGroupIndex:[" + x.getFieldGroupIndex() + "] \u4e0d\u5408\u6cd5");
                        }
                    }
                    return combinationField;
                }).collect(Collectors.toList());
            } else {
                log.info("\u7ec4\u5408\u6761\u4ef6\u4e3a\u7a7a");
            }
            CombineConfigParamAssembly config = new CombineConfigParamAssembly();
            config.setFunctionName("COMMON_COMBINER");
            config.setConditions(combinationFields);
            combineConfigs.add(config);
            CombineConfigParamAssembly phoenixConfig = new CombineConfigParamAssembly();
            phoenixConfig.setParams(JSON.toJSONString(Collections.singletonMap("autoMerge", billMergerRuleDTO.getAutoMergeFlag())));
            phoenixConfig.setFunctionName("PHOENIX_BILL_COMBINER");
            if (!this.jieshibangMergeIds.contains(tenantId)) {
                CombineConfigParamAssembly zeroAmount = this.getCombineConfigByBillNoAndInvoiceType();
                zeroAmount.setFunctionName("ZERO_AMOUNT_COMBINER");
                zeroAmount.setParams(JSON.toJSONString(Collections.singletonMap("allowZeroAmount", 1)));
                combineConfigs.add(zeroAmount);
            }
        } else {
            CombineConfigParamAssembly noAutoCombine = this.getCombineConfigByBillNoAndInvoiceType();
            noAutoCombine.setFunctionName("COMMON_COMBINER");
            noAutoCombine.setParams(JSON.toJSONString(Collections.singletonMap("allowOne", 2)));
            combineConfigs.add(noAutoCombine);
        }
        if (!this.jieshibangMergeIds.contains(tenantId)) {
            CombineConfigParamAssembly zeroCombine2 = this.getCombineConfigByBillNoAndInvoiceType();
            zeroCombine2.setFunctionName("ZERO_AMOUNT_COMBINER");
            zeroCombine2.setParams(JSON.toJSONString(Collections.singletonMap("allowZeroAmount", 2)));
            combineConfigs.add(zeroCombine2);
        }
        return combineConfigs;
    }

    protected BillMergeRequest prepareMergeRequest(BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vos, String tenantId, String loanItem) {
        String priceMethod;
        HashMap map;
        BillMergeRequest request = new BillMergeRequest();
        if (this.xufujiMergeIds.contains(tenantId)) {
            CombineConfigParamAssembly xufuji_combineConfig = new CombineConfigParamAssembly();
            xufuji_combineConfig.setFunctionName("NTOONE_COMBINER");
            map = Maps.newHashMap();
            map.put("valueUpperBound", CommonTools.isEmpty((String)billMergerRuleDTO.getInvoiceLimit()) ? "999999.99" : billMergerRuleDTO.getInvoiceLimit());
            map.put("itemUpperBound", "2000");
            map.put("checked", Objects.equals("outer", loanItem) ? "true" : "false");
            map.put("markedStatus", "UNUSED");
            map.put("combineMethod", "Auto");
            if (!CommonTools.isEmpty((String)billMergerRuleDTO.getExtStr())) {
                Map extMap = JsonUtils.writeJsonToMap((String)billMergerRuleDTO.getExtStr());
                map.putAll(extMap);
            }
            map.put("amountField", Objects.equals("0", priceMethod = vos.get(0).getOrdSalesbillVO().getPriceMethod()) ? "amountWithoutTax" : "amountWithTax");
            map.put("itemFields", new String[]{"itemCode"});
            xufuji_combineConfig.setParams(JsonUtils.writeObjectToJson((Object)map));
            request.setCombineConfigs((List)Lists.newArrayList((Object[])new CombineConfigParamAssembly[]{xufuji_combineConfig}));
        } else {
            List<CombineConfigParamAssembly> combineConfigParamAssemblies = this.parseCombineConfig(billMergerRuleDTO, tenantId);
            request.setCombineConfigs(combineConfigParamAssemblies);
        }
        if (this.jieshibangMergeIds.contains(tenantId)) {
            MergeConfigParamAssembly jieShiBang_merger = new MergeConfigParamAssembly();
            jieShiBang_merger.setFunctionName("JIE_SHI_BANG");
            ArrayList jieShiBang_mergerConfig = Lists.newArrayList((Object[])new MergeConfigParamAssembly[]{jieShiBang_merger});
            request.setMergeConfigs((List)jieShiBang_mergerConfig);
        } else if (this.xufujiMergeIds.contains(tenantId)) {
            MergeConfigParamAssembly xufuji_merger = new MergeConfigParamAssembly();
            xufuji_merger.setFunctionName("XUFUJI_MERGER");
            map = Maps.newHashMap();
            map.put("checked", Objects.equals("inner", loanItem) ? "true" : "false");
            priceMethod = vos.get(0).getOrdSalesbillVO().getPriceMethod();
            map.put("isWithoutTax", Objects.equals("0", priceMethod) ? "true" : "false");
            map.put("discountRate", null);
            map.put("mergeDiffPrice", "false");
            map.put("calcMethod", "BY_QUANTITY_I");
            xufuji_merger.setParams(JsonUtils.writeObjectToJson((Object)map));
            ArrayList xufuji_mergerConfig = Lists.newArrayList((Object[])new MergeConfigParamAssembly[]{xufuji_merger});
            request.setMergeConfigs((List)xufuji_mergerConfig);
        } else {
            List<MergeConfigParamAssembly> mergeConfigParamAssemblies = this.parseMergeConfig(billMergerRuleDTO);
            request.setMergeConfigs(mergeConfigParamAssemblies);
        }
        Map map2 = vos.stream().collect(Collectors.groupingBy(x -> x.getOrdSalesbillVO().getSalesbillId(), HashMap::new, Collectors.mapping(x -> x.getOrdSalesbillItemVO().getSalesbillItemId(), Collectors.toList())));
        ArrayList details = new ArrayList();
        map2.forEach((k, v) -> {
            BillMergeDetail detail = new BillMergeDetail();
            detail.setBillId(k);
            detail.setItemIds(v);
            details.add(detail);
        });
        request.setBills(details);
        return request;
    }

    protected MergeToolsRequest prepareMergeToolsRequest(BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vos, String tenantId) {
        MergeToolsRequest request = new MergeToolsRequest();
        List<CombineConfigParamAssembly> combineConfigParamAssemblies = this.parseCombineConfig(billMergerRuleDTO, tenantId);
        request.setCombineConfigs(combineConfigParamAssemblies);
        List<MergeConfigParamAssembly> mergeConfigParamAssemblies = this.parseMergeConfig(billMergerRuleDTO);
        request.setMergeConfigs(mergeConfigParamAssemblies);
        Map map = vos.stream().collect(Collectors.groupingBy(OrdSalesbillDetailVO::getOrdSalesbillVO, HashMap::new, Collectors.mapping(OrdSalesbillDetailVO::getOrdSalesbillItemVO, Collectors.toList())));
        ArrayList details = new ArrayList();
        map.forEach((k, v) -> {
            BillDetail detail = new BillDetail();
            detail.setItems(this.ordSalesbillItemVoMapper.mapToBillItems((List<OrdSalesbillItemVO>)v));
            detail.setMain(this.ordSalesbillVoMapper.mapToBillMain((OrdSalesbillVO)k));
            details.add(detail);
        });
        request.setBills(details);
        return request;
    }

    private CombineConfigParamAssembly getCombineConfigByBillNoAndInvoiceType() {
        CombineConfigParamAssembly combineConfig = new CombineConfigParamAssembly();
        ArrayList<CombinationField> combineFields = new ArrayList<CombinationField>();
        CombinationField billNo = new CombinationField();
        billNo.setField(MainMapping.getField((String)"billNo"));
        billNo.setType(CombinationField.FieldType.MAIN);
        combineFields.add(billNo);
        CombinationField invoiceType = new CombinationField();
        invoiceType.setField(ItemMapping.getField((String)"invoiceType"));
        invoiceType.setType(CombinationField.FieldType.ITEM_PRIORITY);
        combineFields.add(invoiceType);
        combineConfig.setConditions(combineFields);
        return combineConfig;
    }

    public MakeOutInvoiceResponse batchRequestMerge(Supplier<Response<MergeResponse>> requestSupplier, List outSplitGroupList, Map<List<OrdSalesbillDetailVO>, BillMergerRuleDTO> detailVoAndRule) {
        Response<MergeResponse> response = requestSupplier.get();
        if (response.isOk()) {
            MergeResponse result = (MergeResponse)response.getResult();
            HashMap sourceRuleMap = new HashMap();
            HashMap sourceSplitRuleMap = new HashMap();
            detailVoAndRule.forEach((vo, ruleDTO) -> {
                OrdSalesbillDetailVO detailVO = (OrdSalesbillDetailVO)vo.get(0);
                OrdSalesbillVO billVO = detailVO.getOrdSalesbillVO();
                billVO.setInvoiceType(AbstractMergeAdapter.getInvoiceType(detailVO));
                BaseRuleBean baseRuleBean = this.billAdapterService.getBaseRuleBean(billVO);
                vo.forEach(x -> {
                    sourceRuleMap.put(x.getOrdSalesbillVO().getSalesbillId(), ruleDTO);
                    sourceSplitRuleMap.put(x.getOrdSalesbillVO().getSalesbillId(), baseRuleBean);
                });
            });
            HashMap targetRuleMap = new HashMap();
            HashMap targetSplitRuleMap = new HashMap();
            Optional.ofNullable(result.getMergeRelations()).ifPresent(x -> {
                for (MergeRelationVo mergeRelationVo : x) {
                    Long sourceMainId = ((SourceDto)mergeRelationVo.getSources().iterator().next()).getSourceMainId();
                    BillMergerRuleDTO billMergerRuleDTO = (BillMergerRuleDTO)sourceRuleMap.get(sourceMainId);
                    targetRuleMap.put(mergeRelationVo.getTargetItemId(), billMergerRuleDTO);
                    targetSplitRuleMap.put(mergeRelationVo.getTargetItemId(), sourceSplitRuleMap.get(sourceMainId));
                }
            });
            HashMap<BillMergerRuleDTO, List> billMergedRuleMap = new HashMap<BillMergerRuleDTO, List>();
            Optional.ofNullable(result.getBills()).ifPresent(x -> {
                for (BillDetail billDetail : x) {
                    for (BillItem item : billDetail.getItems()) {
                        BillMergerRuleDTO billMergerRuleDTO = (BillMergerRuleDTO)targetRuleMap.get(item.getId());
                        List detailList = billMergedRuleMap.computeIfAbsent(billMergerRuleDTO, k -> new ArrayList());
                        if (detailList.contains(billDetail)) continue;
                        detailList.add(billDetail);
                    }
                }
            });
            billMergedRuleMap.forEach((k, v) -> {
                BaseRuleBean baseRuleBean = (BaseRuleBean)targetSplitRuleMap.get(((BillItem)((BillDetail)v.get(0)).getItems().iterator().next()).getId());
                this.addSplitGroupFromMergedBills((List<BillDetail>)v, (BillMergerRuleDTO)k, baseRuleBean, outSplitGroupList);
            });
            HashMap<BaseRuleBean, List> nonMergeSplitRuleMap = new HashMap<BaseRuleBean, List>();
            Optional.ofNullable(result.getNonMerge()).ifPresent(x -> {
                for (MergeResponse.NonMergeBillVo nonMergeBillVo : x) {
                    BaseRuleBean baseRuleBean = (BaseRuleBean)sourceSplitRuleMap.get(((BillDetail)nonMergeBillVo.getBills().get(0)).getMain().getId());
                    List nonMergeBillVos = nonMergeSplitRuleMap.computeIfAbsent(baseRuleBean, k -> new ArrayList());
                    if (nonMergeBillVos.contains(nonMergeBillVo)) continue;
                    nonMergeBillVos.add(nonMergeBillVo);
                }
            });
            nonMergeSplitRuleMap.forEach((k, v) -> this.addSplitGroupFromNonMerge((List<MergeResponse.NonMergeBillVo>)v, (BaseRuleBean)k, outSplitGroupList));
            return null;
        }
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.Fail);
        makeOutInvoiceResponse.setMessage(response.getMessage());
        return makeOutInvoiceResponse;
    }

    protected MakeOutInvoiceResponse requestMerge(Supplier<Response<MergeResponse>> requestSupplier, List outSplitGroupList, BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vo) {
        Response<MergeResponse> response = requestSupplier.get();
        return this.requestMerge(response, outSplitGroupList, billMergerRuleDTO, vo);
    }

    protected MakeOutInvoiceResponse requestMerge(Response<MergeResponse> response, List outSplitGroupList, BillMergerRuleDTO billMergerRuleDTO, List<OrdSalesbillDetailVO> vo) {
        if (response.isOk()) {
            OrdSalesbillDetailVO detailVO = vo.get(0);
            OrdSalesbillVO billVO = detailVO.getOrdSalesbillVO();
            billVO.setInvoiceType(AbstractMergeAdapter.getInvoiceType(detailVO));
            BaseRuleBean baseRuleBean = this.billAdapterService.getBaseRuleBean(billVO);
            MergeResponse mergeResponse = (MergeResponse)response.getResult();
            List bills = mergeResponse.getBills();
            this.addSplitGroupFromMergedBills(bills, billMergerRuleDTO, baseRuleBean, outSplitGroupList);
            this.addSplitGroupFromNonMerge(mergeResponse.getNonMerge(), baseRuleBean, outSplitGroupList);
            return null;
        }
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        makeOutInvoiceResponse.setCode(com.xforceplus.xplatframework.model.Response.Fail);
        makeOutInvoiceResponse.setMessage(response.getMessage());
        return makeOutInvoiceResponse;
    }

    private void addSplitGroupFromMergedBills(List<BillDetail> bills, BillMergerRuleDTO billMergerRuleDTO, BaseRuleBean baseRuleBean, List outSplitGroupList) {
        if (CollectionUtils.isNotEmpty(bills)) {
            for (BillDetail bill : bills) {
                ArrayList mergeVo = new ArrayList();
                List<OrdSalesbillItemVO> ordSalesbillItemVOS = this.ordSalesbillItemVoMapper.mapToItemVoList(bill.getItems());
                OrdSalesbillVO ordSalesbillVO = this.ordSalesbillVoMapper.mapToBillVo(bill.getMain());
                ordSalesbillItemVOS.forEach(item -> mergeVo.add(new OrdSalesbillDetailVO(ordSalesbillVO, item)));
                SplitGroup splitGroup = SplitGroup.builder().ruleId(baseRuleBean.getRuldId()).mergeType(Integer.valueOf(billMergerRuleDTO.getAutoMergeFlag() != false ? BillMergeType.AUTO_MERGE.value() : BillMergeType.AUTO_COMBINE.value())).batchNo(((BillItem)bill.getItems().get(0)).getBatchNo()).build();
                splitGroup.setList(mergeVo);
                outSplitGroupList.add(splitGroup);
            }
        }
    }

    private void addSplitGroupFromNonMerge(List<MergeResponse.NonMergeBillVo> nonMerge, BaseRuleBean baseRuleBean, List outSplitGroupList) {
        if (CollectionUtils.isNotEmpty(nonMerge)) {
            for (MergeResponse.NonMergeBillVo nonMergeBillVo : nonMerge) {
                nonMergeBillVo.getBills().forEach(bill -> {
                    ArrayList nonVo = new ArrayList();
                    List<OrdSalesbillItemVO> ordSalesbillItemVOS = this.ordSalesbillItemVoMapper.mapToItemVoList(bill.getItems());
                    OrdSalesbillVO ordSalesbillVO = this.ordSalesbillVoMapper.mapToBillVo(bill.getMain());
                    ordSalesbillItemVOS.forEach(item -> nonVo.add(new OrdSalesbillDetailVO(ordSalesbillVO, item)));
                    SplitGroup splitGroup = SplitGroup.builder().ruleId(baseRuleBean.getRuldId()).mergeType(Integer.valueOf(BillMergeType.NONE.value())).batchNo(((BillItem)bill.getItems().get(0)).getBatchNo()).build();
                    splitGroup.setList(nonVo);
                    outSplitGroupList.add(splitGroup);
                });
            }
        }
    }
}

