/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.xforceplus.adapter.core.client.BillHistoryClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.receipt.vo.request.BillRollBackRequest;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollBackAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(RollBackAdapter.class);
    @Autowired
    private BillHistoryClient historyClient;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        Map map = JsonUtils.parseMap((String)JsonUtils.serialize(params.get("request")));
        Long historyId = Long.valueOf(String.valueOf(map.get("id")));
        Long billId = Long.valueOf(String.valueOf(map.get("salesbillId")));
        UserInfo info = (UserInfo)this.userInfoHolder.get();
        BillRollBackRequest request = new BillRollBackRequest();
        request.setHistoryId(historyId);
        request.setBillId(billId);
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(info.getUserId()));
        userInfo.setGroupId(Long.valueOf(info.getGroupId()));
        userInfo.setUserName(info.getUserName());
        request.setUserInfo(userInfo);
        com.xforceplus.receipt.vo.response.Response response = this.historyClient.rollBack(tenantId, request);
        if (!response.isOk()) {
            return Response.failed((String)response.getMessage());
        }
        return Response.ok((String)"\u64a4\u9500\u6210\u529f!");
    }

    public String adapterName() {
        return "rollBack";
    }
}

