/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.BillUpdateClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.adapter.vo.CheckPreInvoicesBeforeDelAndNoDelete;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.receipt.vo.AbandonVo;
import com.xforceplus.receipt.vo.BillCheckResult;
import com.xforceplus.receipt.vo.BillMain;
import com.xforceplus.receipt.vo.request.BillAbandonCheckRequest;
import com.xforceplus.receipt.vo.request.BillAbandonRequest;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.util.CommonTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesBillDeleteOrAbandonAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(SalesBillDeleteOrAbandonAdapter.class);
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private BillOperationAdapterService operationAdapterService;
    @Autowired
    private BillAdapterService adapterService;
    @Autowired
    private BillItemClient itemClient;
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private BillUpdateClient updateClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private BillEsSearchClient esSearchClient;

    public Object process(AdapterParams adapterParams) {
        List list;
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Map headers = (Map)params.get("headers");
        String salesbillNo = (String)params.get("salesbillNo");
        String salesbillType = (String)params.get("salesbillType");
        String businessBillType = (String)params.get("businessBillType");
        String groupId = String.valueOf(headers.get("groupId"));
        String userId = String.valueOf(headers.get("userId"));
        String userName = String.valueOf(headers.get("userName"));
        SearchModel searchModel = this.getCheckModel(salesbillNo, salesbillType, businessBillType);
        com.xforceplus.receipt.vo.UserInfo userInfo = new com.xforceplus.receipt.vo.UserInfo();
        userInfo.setUserId(Long.valueOf(Long.parseLong(userId)));
        userInfo.setGroupId(Long.valueOf(Long.parseLong(groupId)));
        userInfo.setUserName(userName);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        BillAbandonCheckRequest abandonCheckRequest = new BillAbandonCheckRequest();
        abandonCheckRequest.setSearchModel(this.searchModelMapper.mapToAbandonSearchModel(searchModel));
        Response checkResponse = this.updateClient.abandonBillCheck(tenantId, abandonCheckRequest);
        String errorResult = "";
        if (checkResponse.isOk()) {
            Set successId = ((AbandonVo)checkResponse.getResult()).getSuccessId();
            if (!successId.isEmpty()) {
                ArrayList list2 = new ArrayList(successId);
                com.xforceplus.xplatframework.model.Response r = this.adapterService.abandonOrDelPreInvoice(Boolean.valueOf(false), list2);
                log.info("\u6821\u9a8c\u9884\u5236\u53d1\u7968\u8fd4\u56de:{}", (Object)JsonUtils.writeObjectToJson((Object)r));
                if (!com.xforceplus.xplatframework.model.Response.OK.equals(r.getCode())) {
                    errorResult = r.getMessage();
                } else {
                    List<Long> failIds;
                    CheckPreInvoicesBeforeDelAndNoDelete checkPreResult;
                    List results = ((AbandonVo)checkResponse.getResult()).getCheckResults();
                    if (!CollectionUtils.isEmpty((Collection)results) && r.getResult() != null && (checkPreResult = (CheckPreInvoicesBeforeDelAndNoDelete)JsonUtils.writeFastJsonToObject((String)JsonUtils.writeObjectToJson((Object)r.getResult()), CheckPreInvoicesBeforeDelAndNoDelete.class)) != null && !(failIds = checkPreResult.getNoDeleteBillIds()).isEmpty()) {
                        errorResult = "\u5df2\u5b58\u5728\u7533\u8bf7\u4e2d\u6216\u5df2\u7533\u8bf7\u7684\u7ea2\u5b57\u4fe1\u606f \u6216\u8005 \u9884\u5236\u53d1\u7968\u5728\u5f00\u7968\u4e2d\u548c\u62c6\u7968\u53d8\u66f4\u4e2d";
                    }
                }
            } else {
                AbandonVo abandonVo = (AbandonVo)checkResponse.getResult();
                List checkResults = abandonVo.getCheckResults();
                errorResult = ((BillCheckResult)checkResults.get(0)).getMsg();
            }
        } else {
            errorResult = checkResponse.getMessage();
        }
        BillMain billMain = null;
        Response<ResPageList<BillMain>> resPageListResponse = this.getResPageListResponse(tenantId, salesbillNo, salesbillType, businessBillType);
        if (resPageListResponse.isOk() && !CollectionUtils.isEmpty((Collection)(list = ((ResPageList)resPageListResponse.getResult()).getList()))) {
            billMain = (BillMain)list.get(0);
        }
        if (!CommonTools.isEmpty((String)errorResult) || billMain == null) {
            if (billMain == null) {
                errorResult = "\u4e3a\u627e\u5230\u5bf9\u5e94\u5bf9\u5e94\u5355\u636e";
            }
            this.distribute(errorResult, billMain, -1, headers, salesbillNo);
            return null;
        }
        BillAbandonRequest abandonRequest = new BillAbandonRequest();
        abandonRequest.setUserInfo(userInfo);
        Long id = billMain.getId();
        abandonRequest.setBillIds((List)Lists.newArrayList((Object[])new Long[]{id}));
        log.info("\u4f5c\u5e9f\u4e1a\u52a1\u5355{}, \u8bf7\u6c42\u4e2d\u53f0\u53c2\u6570{}", (Object)salesbillNo, (Object)JsonUtils.writeObjectToJson((Object)abandonRequest));
        Response response = this.updateClient.abandonBill(tenantId, abandonRequest);
        boolean ok = response.isOk();
        if (ok) {
            this.distribute(errorResult, billMain, 1, headers, salesbillNo);
        }
        return ok ? com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage()) : com.xforceplus.xplatframework.model.Response.ok((String)response.getMessage(), (Object)response.getResult());
    }

    private Response<ResPageList<BillMain>> getResPageListResponse(String tenantId, String salesbillNo, String salesbillType, String businessBillType) {
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest billElasticSearchRequest = new SearchRequest();
        ArrayList toFields = Lists.newArrayList((Object[])new String[]{"id", "billNo", "sellerTaxNo", "purchaserTaxNo"});
        billElasticSearchRequest.setIncludes((List)toFields);
        ArrayList searchFilters = Lists.newArrayList();
        SearchFilter billNo_searchFilter = new SearchFilter();
        billNo_searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{salesbillNo}));
        billNo_searchFilter.setFieldName("billNo");
        billNo_searchFilter.setFieldQueryType(Operator.eq);
        searchFilters.add(billNo_searchFilter);
        SearchFilter salesbillType_searchFilter = new SearchFilter();
        salesbillType_searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{salesbillType}));
        salesbillType_searchFilter.setFieldName("billType");
        salesbillType_searchFilter.setFieldQueryType(Operator.eq);
        searchFilters.add(salesbillType_searchFilter);
        SearchFilter businessBillType_searchFilter = new SearchFilter();
        businessBillType_searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{businessBillType}));
        businessBillType_searchFilter.setFieldName("businessBillType");
        businessBillType_searchFilter.setFieldQueryType(Operator.eq);
        searchFilters.add(businessBillType_searchFilter);
        ArrayList tempSearchFilters = Lists.newArrayList();
        tempSearchFilters.add(searchFilters);
        billElasticSearchRequest.setGroups((List)tempSearchFilters);
        billElasticSearchRequest.setPageNo(Integer.valueOf(1));
        billElasticSearchRequest.setPageSize(Integer.valueOf(5000));
        billElasticSearchRequest.setIndex("ord_salesbill");
        billElasticSearchRequest.setType("ord_salesbill_item:salesbill_id");
        billElasticSearchRequest.setChildType("");
        billElasticSearchRequest.setChildGroups((List)Lists.newArrayList());
        request.setSearchModel(billElasticSearchRequest);
        Response resPageListResponse = this.esSearchClient.billMainElasticSearch(tenantId, request);
        return resPageListResponse;
    }

    private void distribute(String processRemark, BillMain billMain, int code, Map header, String salesbillNo) {
        HashMap sendMap = Maps.newHashMap();
        ArrayList mainMaps = Lists.newArrayList();
        ArrayList itemMaps = Lists.newArrayList();
        HashMap mainMap = Maps.newHashMap();
        mainMap.put("salesbillNo", salesbillNo);
        mainMap.put("processRemark", processRemark);
        mainMaps.add(mainMap);
        sendMap.put("main", mainMaps);
        sendMap.put("items", itemMaps);
        String remark = JsonUtils.writeObjectToFastJson((Object)sendMap);
        log.info("adapter \u4e0a\u4f20\u4f5c\u5e9f\u4e0b\u53d1\u4e1a\u52a1\u5355:{}", (Object)remark);
        this.operationAdapterService.sendBillMessage(remark, this.headers(header, billMain), Integer.valueOf(code));
    }

    private SearchModel getCheckModel(String salesbillNo, String salesbillType, String businessBillType) {
        SearchModel searchModel = new SearchModel();
        searchModel.setPageSize(Integer.valueOf(5000));
        searchModel.setPageNo(Integer.valueOf(1));
        ArrayList groups = Lists.newArrayList();
        ArrayList group = Lists.newArrayList();
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{salesbillNo}));
        searchFilter.setFieldName("billNo");
        searchFilter.setFieldQueryType(Operator.eq);
        group.add(searchFilter);
        SearchFilter salesbillType_searchFilter = new SearchFilter();
        salesbillType_searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{salesbillType}));
        salesbillType_searchFilter.setFieldName("billType");
        salesbillType_searchFilter.setFieldQueryType(Operator.eq);
        group.add(salesbillType_searchFilter);
        SearchFilter businessBillType_searchFilter = new SearchFilter();
        businessBillType_searchFilter.setValue((List)Lists.newArrayList((Object[])new String[]{businessBillType}));
        businessBillType_searchFilter.setFieldName("businessBillType");
        businessBillType_searchFilter.setFieldQueryType(Operator.eq);
        group.add(businessBillType_searchFilter);
        SearchFilter status_searchFilter = new SearchFilter();
        status_searchFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{1}));
        status_searchFilter.setFieldName("businessBillType");
        status_searchFilter.setFieldQueryType(Operator.eq);
        group.add(businessBillType_searchFilter);
        groups.add(group);
        searchModel.setGroups((List)groups);
        return searchModel;
    }

    public String adapterName() {
        return "salesBillDeleteOrAbandon";
    }

    private Map headers(Map headers, BillMain main) {
        if (main != null) {
            headers.put("businessNo", main.getBillNo());
            headers.put("sellerTaxNo", main.getSellerTaxNo());
            headers.put("purchaserTaxNo", main.getPurchaserTaxNo());
        }
        return headers;
    }
}

