/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SimpleBillMapper;
import com.xforceplus.phoenix.bill.client.model.SimpleBillMainResponse;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillQuerySimpleInfoAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillQuerySimpleInfoAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private SimpleBillMapper adapterSimpleBillMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object o = paramMap.get("salesBillIdList");
        List billIds = (List)o;
        BillMainQueryRequest queryRequest = new BillMainQueryRequest();
        queryRequest.setBillIds(billIds);
        log.info("querySimpleInfoOfSalesBillRequest:{}", (Object)queryRequest);
        Response response = this.billMainClient.queryBills(tenantId, queryRequest);
        SimpleBillMainResponse mainResponse = new SimpleBillMainResponse();
        mainResponse.addBillMain(this.adapterSimpleBillMapper.mapToSimpleBillResponses((List)response.getResult()));
        return mainResponse;
    }

    public String adapterName() {
        return "querySimpleInfoOfSalesBill";
    }
}

