/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.component.CommonService;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.request.BillItemSummaryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;

@Component
public class BillDetailCountNewAdapter
implements IAdapter<AdapterParams, Object> {
    private final BillItemClient billItemClient;
    private final CommonService commonService;

    public BillDetailCountNewAdapter(BillItemClient billItemClient, CommonService commonService) {
        this.billItemClient = billItemClient;
        this.commonService = commonService;
    }

    @Retryable(value={Throwable.class}, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        SearchModel searchModel = (SearchModel)adapterParams.getParams().get("searchModel");
        Tuple2<List<Long>, List<Integer>> tupleResult = this.commonService.buildItemConditionOnlyId((List)searchModel.getChildGroups().get(0));
        List bizOrderIdList = (List)tupleResult.getT1();
        List statusList = (List)tupleResult.getT2();
        if (CollectionUtils.isEmpty((Collection)bizOrderIdList)) {
            return 0L;
        }
        BillItemSummaryRequest request = new BillItemSummaryRequest();
        request.setBillIds(bizOrderIdList);
        request.setStatus(statusList);
        Response response = this.billItemClient.countByBillIds(tenantId, request);
        return Optional.ofNullable(response.getResult()).orElse(0L);
    }

    public String adapterName() {
        return "getBillDetailCountNew";
    }
}

