/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.AutoBillMainClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillMainMapper;
import com.xforceplus.phoenix.bill.client.model.BillQueryResponse;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMain;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillListByIdQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillListByIdQueryAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private AutoBillMainClient autoBillMainClient;
    @Autowired
    private InvoiceBillMainMapper invoiceBillMainMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        com.xforceplus.receipt.vo.response.Response autoBillResponse;
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        List billIds = (List)paramMap.get("billIdList");
        BillMainQueryRequest queryRequest = new BillMainQueryRequest();
        queryRequest.setBillIds(billIds);
        log.info("querySimpleInfoOfSalesBillRequest:{}", (Object)queryRequest);
        com.xforceplus.receipt.vo.response.Response billResponse = this.billMainClient.queryBills(tenantId, queryRequest);
        List result = (List)billResponse.getResult();
        List<InvoiceBillMain> invoiceBillMains = this.invoiceBillMainMapper.mapToInvoiceBillMains(result);
        if ((CollectionUtils.isEmpty((Collection)result) || result.size() < billIds.size()) && !CollectionUtils.isEmpty((Collection)((Collection)(autoBillResponse = this.autoBillMainClient.queryAutoBill(tenantId, billIds)).getResult()))) {
            invoiceBillMains.addAll(this.invoiceBillMainMapper.mapToInvoiceBillMains((List)autoBillResponse.getResult()));
        }
        BillQueryResponse billQueryResponse = new BillQueryResponse();
        if (invoiceBillMains.size() > 0) {
            billQueryResponse.setResult(invoiceBillMains);
            billQueryResponse.setCode(Response.OK);
            billQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        } else {
            billQueryResponse.setCode(Response.Fail);
            billQueryResponse.setMessage("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5355\u636e\u4fe1\u606f");
        }
        return billQueryResponse;
    }

    public String adapterName() {
        return "queryBillByIds";
    }
}

