/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Maps;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.InvoiceBillItemMapper;
import com.xforceplus.adapter.mapstruct.InvoiceBillMainExtMapper;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillItem;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMainExt;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillMainAndItemByIdQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillMainAndItemByIdQueryAdapter.class);
    @Autowired
    private InvoiceBillItemMapper invoiceBillItemMapper;
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    InvoiceBillMainExtMapper invoiceBillMainExtMapper;
    private static final String successMains_key = "successMains";
    private static final String successItems_key = "successItems";
    private static final String source = "source";

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams param) {
        log.info("\u6267\u884cgetBillDataMapByIds");
        String tenantId = param.getTenantId();
        Map params = param.getParams();
        List billIds = (List)params.get("successSalesBillIds");
        BillMainQueryRequest queryRequest = new BillMainQueryRequest();
        queryRequest.setBillIds(billIds);
        log.info("queryBillMainByIdsRequest:{}", (Object)queryRequest);
        Response response = this.billMainClient.queryAutoBillOrBills(tenantId, billIds);
        List<InvoiceBillMainExt> billExtList = this.invoiceBillMainExtMapper.mapToInvoiceBillMainExt((List)response.getResult());
        Response itemResponse = this.billItemClient.queryBillItemByBillId(tenantId, billIds);
        List<InvoiceBillItem> invoiceBillItems = this.invoiceBillItemMapper.mapToInvoiceBillItems((List)itemResponse.getResult());
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(successMains_key, billExtList);
        hashMap.put(successItems_key, invoiceBillItems);
        hashMap.put(source, "adapter");
        return hashMap;
    }

    public String adapterName() {
        return "getBillDataMapByIds";
    }
}

