/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillHistoryClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillHistoryVoMapper;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.phoenix.bill.client.model.BillHistoryResponse;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillQueryHistoryAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillHistoryClient billHistoryClient;
    @Autowired
    private BillHistoryVoMapper billHistoryVoMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Map parse = JsonUtils.parseMap((String)JsonUtils.serialize(params.get("request")));
        String billId = String.valueOf(parse.get("salesbillId"));
        com.xforceplus.receipt.vo.response.Response listResponse = this.billHistoryClient.queryHistory(tenantId, Long.valueOf(billId));
        List result = (List)listResponse.getResult();
        BillHistoryResponse response = new BillHistoryResponse();
        response.setCode(Response.OK);
        response.setResult(this.billHistoryVoMapper.mapToBillHistoryVos(result));
        return response;
    }

    public String adapterName() {
        return "queryHistory";
    }
}

