/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.query.BillGetBillListOptimizeAdapter;
import com.xforceplus.adapter.core.client.BillEsSearchClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillVoMapper;
import com.xforceplus.adapter.mapstruct.SearchModelMapper;
import com.xforceplus.adapter.model.MainMapping;
import com.xforceplus.adapter.utils.JsonUtils;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.ReceiptSearchSort;
import com.xforceplus.receipt.vo.request.BillElasticSearchRequest;
import com.xforceplus.receipt.vo.request.SearchRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BIllMergeQueryMainNewAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BIllMergeQueryMainNewAdapter.class);
    @Autowired
    private BillEsSearchClient billEsSearchClient;
    @Autowired
    private SearchModelMapper searchModelMapper;
    @Autowired
    private OrdSalesbillVoMapper ordSalesbillVoMapper;

    public Object process(AdapterParams adapterParams) {
        SearchModel searchModel = (SearchModel)adapterParams.getParams().get("billSearch");
        List mainField = (List)adapterParams.getParams().get("mainField");
        SearchModelUtil.mapFields((SearchModel)searchModel);
        log.info("bIllMergeQueryMainNewAdapterSearch:{},searchModelMapper:{}", (Object)JsonUtils.serialize((Object)searchModel), (Object)JsonUtils.serialize((Object)this.searchModelMapper));
        BillElasticSearchRequest request = new BillElasticSearchRequest();
        SearchRequest searchRequest = this.searchModelMapper.mapToSearchRequest(searchModel);
        request.setSearchModel(searchRequest);
        ReceiptSearchSort searchSort = BillGetBillListOptimizeAdapter.initSearchSorts(searchModel.getSort());
        request.getSearchModel().setSearchSort(searchSort);
        request.getSearchModel().setIncludes(mainField.stream().map(MainMapping::getField).collect(Collectors.toList()));
        Response response = this.billEsSearchClient.billMainElasticSearch(adapterParams.getTenantId(), request);
        if (response.isOk()) {
            ResPageList pageList = (ResPageList)response.getResult();
            List billMains = pageList.getList();
            return new ResPageList(pageList.getTotal(), this.ordSalesbillVoMapper.mapToBillVos(billMains));
        }
        return new ResPageList(0L, (List)Lists.newArrayList());
    }

    public String adapterName() {
        return "getOrdSalesbillVOSNew";
    }
}

