/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillItemExtMapper;
import com.xforceplus.phoenix.bill.client.model.QueryBillItemData;
import com.xforceplus.phoenix.bill.client.model.QueryBillItemModel;
import com.xforceplus.phoenix.bill.client.model.QueryBillItemResponse;
import com.xforceplus.receipt.vo.response.PageResp;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillItemByNoQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillItemByNoQueryAdapter.class);
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private BillItemExtMapper billItemExtMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        QueryBillItemModel model = (QueryBillItemModel)params.get("model");
        Integer pageNo = model.getPageNo();
        Integer pageSize = model.getPageSize();
        Response byNo = this.billItemClient.getByNo(tenantId, model.getSalesbillNo(), pageNo.intValue(), pageSize.intValue());
        PageResp result = (PageResp)byNo.getResult();
        List rows = result.getRows();
        long total = result.getSummary().getTotal();
        QueryBillItemResponse queryBillItemResponse = new QueryBillItemResponse();
        queryBillItemResponse.setCode(1);
        queryBillItemResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        QueryBillItemData billItemData = new QueryBillItemData();
        billItemData.setTotal(total);
        billItemData.setList(this.billItemExtMapper.mapToBillItemExtList(rows));
        queryBillItemResponse.setData(billItemData);
        return queryBillItemResponse;
    }

    public String adapterName() {
        return "querySalesbillItemByBillNo";
    }
}

