/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.component.CommonService;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.OrdSalesbillItemVoMapper;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.request.BillItemSummaryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;

@Component
public class BillMergeQueryItemNewAdapter
implements IAdapter<AdapterParams, Object> {
    private final BillItemClient billItemClient;
    private final CommonService commonService;
    private final OrdSalesbillItemVoMapper ordSalesbillItemVoMapper;

    public BillMergeQueryItemNewAdapter(BillItemClient billItemClient, CommonService commonService, OrdSalesbillItemVoMapper ordSalesbillItemVoMapper) {
        this.billItemClient = billItemClient;
        this.commonService = commonService;
        this.ordSalesbillItemVoMapper = ordSalesbillItemVoMapper;
    }

    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        SearchModel searchModel = (SearchModel)params.get("billSearch");
        Long itemId = (Long)params.get("itemId");
        Tuple2<List<Long>, List<Integer>> tupleResult = this.commonService.buildItemConditionOnlyId((List)searchModel.getChildGroups().get(0));
        List bizOrderIdList = (List)tupleResult.getT1();
        List statusList = (List)tupleResult.getT2();
        if (CollectionUtils.isEmpty((Collection)bizOrderIdList)) {
            return Lists.newArrayList();
        }
        BillItemSummaryRequest request = new BillItemSummaryRequest();
        request.setBillIds(bizOrderIdList);
        request.setStatus(statusList);
        request.setSize(searchModel.getPageSize());
        request.setItemId(itemId);
        Response response = this.billItemClient.queryByPage(tenantId, request);
        if (response.isOk()) {
            return ((List)response.getResult()).stream().map(item -> {
                OrdSalesbillDetailVO billDetailVo = new OrdSalesbillDetailVO();
                billDetailVo.setOrdSalesbillItemVO(this.ordSalesbillItemVoMapper.mapToItemVo((BillItem)item));
                return billDetailVo;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public String adapterName() {
        return "getDetailFromSql";
    }
}

