/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.enums.BillItemStatus;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Component
public class CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonService.class);

    public Tuple2<List<Long>, List<Integer>> buildItemConditionOnlyId(List<SearchFilter> filterList) {
        List<Object> salesbillIdList = Lists.newArrayList();
        List<Object> statusList = Lists.newArrayList();
        for (SearchFilter filter : filterList) {
            if ("salesbillId".equals(filter.getFieldName()) || "billId".equals(filter.getFieldName())) {
                salesbillIdList = filter.getValue().stream().map(String::valueOf).map(Long::parseLong).collect(Collectors.toList());
            }
            if (!"status".equals(filter.getFieldName())) continue;
            List tempStatusList = filter.getValue().stream().map(String::valueOf).map(Integer::parseInt).collect(Collectors.toList());
            statusList = Operator.not_in == filter.getFieldQueryType() ? EnumUtils.getEnumList(BillItemStatus.class).stream().map(BillItemStatus::value).filter(r -> !tempStatusList.contains(r)).collect(Collectors.toList()) : tempStatusList;
        }
        return Tuples.of((Object)salesbillIdList, (Object)statusList);
    }
}

