/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillSourceClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillSourceRelationshipMapper;
import com.xforceplus.phoenix.bill.client.model.BillSourceResponse;
import com.xforceplus.xplatframework.model.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillSourceByBatchNoQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillSourceByBatchNoQueryAdapter.class);
    @Autowired
    private BillSourceClient billSourceClient;
    @Autowired
    private BillSourceRelationshipMapper billSourceRelationshipMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        Object o = params.get("batchNo");
        com.xforceplus.receipt.vo.response.Response listResponse = this.billSourceClient.querySourceRelationByBatchNo(tenantId, Long.valueOf(String.valueOf(o)));
        List result = (List)listResponse.getResult();
        BillSourceResponse billSourceResponse = new BillSourceResponse();
        if (CollectionUtils.isEmpty((Collection)result)) {
            billSourceResponse.setCode(Response.Fail);
            billSourceResponse.setMessage("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7ed3\u679c");
            return billSourceResponse;
        }
        billSourceResponse.setCode(Response.OK);
        billSourceResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        billSourceResponse.setResult(this.billSourceRelationshipMapper.mapToBillSourceRelationships(result));
        return billSourceResponse;
    }

    public String adapterName() {
        return "queryBillSourceByBatchNo";
    }
}

