/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.enums;

import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.EnumUtils;

public interface ValueEnum<T> {
    public T getValue();

    public static <E extends Enum<E>, T> boolean isValid(Class<E> clazz, T value) {
        return ValueEnum.getEnumByValue(clazz, value).isPresent();
    }

    public static <E extends Enum<E>, T> Optional<E> getEnumByValue(@NonNull Class<E> clazz, T value) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return value == null ? Optional.empty() : EnumUtils.getEnumList(clazz).stream().filter(c -> value.equals(((ValueEnum)((Object)c)).getValue())).findFirst();
    }

    public static <E extends Enum<E>, T> Optional<E> getEnumByOrdinal(@NonNull Class<E> clazz, Integer ordinal) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ordinal == null ? Optional.empty() : EnumUtils.getEnumList(clazz).stream().filter(p -> p.ordinal() == ordinal.intValue()).findFirst();
    }

    public static <E extends Enum<E>, T> T getValueByOrdinal(@NonNull Class<E> clazz, Integer ordinal) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ValueEnum.getEnumByOrdinal(clazz, ordinal).map(ValueEnum::getValue).orElse(null);
    }

    public static <E extends Enum<E>, T> Integer getOrdinalByValue(@NonNull Class<E> clazz, T value) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ValueEnum.getEnumByValue(clazz, value).map(Enum::ordinal).orElse(null);
    }
}

