/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.SummaryResultMapper;
import com.xforceplus.adapter.utils.SearchModelUtil;
import com.xforceplus.phoenix.bill.client.api.adapter.BillAdapterService;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillSummaryResponse;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.receipt.vo.request.BillSearchModel;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class BillDeailHeadSummaryAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private SummaryResultMapper summaryResultMapper;
    @Autowired
    private BillAdapterService billAdapterService;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        BillSearchModel billSearchModel = (BillSearchModel)adapterParams.getParams().get("billSearchModel");
        SearchModel searchModel = this.billAdapterService.buildHasSearchModelForAdapter(billSearchModel);
        SearchModelUtil.mapFields((SearchModel)searchModel);
        com.xforceplus.receipt.vo.request.BillSearchModel model = new com.xforceplus.receipt.vo.request.BillSearchModel();
        model.setSearchModel(searchModel);
        model.setModel(BillSearchModel.Model.ITEM);
        model.setBillStatus(billSearchModel.getBillStatus());
        model.setUserRole(billSearchModel.getUserRole());
        model.setUploadSide(billSearchModel.getUploadSide());
        Response summary = this.billMainClient.summary(adapterParams.getTenantId(), model);
        BillSummaryResponse response = new BillSummaryResponse();
        if (summary.isOk()) {
            response.setCode(BaseResponse.OK);
            List result = (List)summary.getResult();
            response.setMessage("\u67e5\u8be2\u6210\u529f");
            response.setResult(this.summaryResultMapper.mapToResSummaries(result));
        } else {
            response.setMessage(summary.getMessage());
            response.setCode(BaseResponse.Fail);
        }
        return response;
    }

    public String adapterName() {
        return "summaryByDetail";
    }
}

