/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.enums;

import com.xforceplus.adapter.enums.PriceMethodTypeEnum;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;

public class BigDecimalUtil {
    public static BigDecimal queryDetailAllowIssueAmount(OrdSalesbillItemVO item, PriceMethodTypeEnum priceMethod) {
        if (PriceMethodTypeEnum.WITH_PRICE == priceMethod) {
            return BigDecimalUtil.subtract(item.getAmountWithTax(), BigDecimalUtil.add(item.getInnerDiscountWithTax(), item.getOutterDiscountWithTax(), item.getInnerPrepayAmountWithTax(), item.getOutterPrepayAmountWithTax(), item.getAbandonFreezeAmountWithTax(), item.getAlreadyAmountWithTax()));
        }
        return BigDecimalUtil.subtract(item.getAmountWithoutTax(), BigDecimalUtil.add(item.getInnerDiscountWithoutTax(), item.getOutterDiscountWithoutTax(), item.getInnerPrepayAmountWithoutTax(), item.getOutterPrepayAmountWithoutTax(), item.getAbandonFreezeAmountWithoutTax(), item.getAlreadyAmountWithoutTax()));
    }

    public static BigDecimal nullToZero(BigDecimal bd) {
        return Optional.ofNullable(bd).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal add(BigDecimal ... addItem) {
        return Arrays.stream(addItem).map(BigDecimalUtil::nullToZero).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal subtract(BigDecimal bd1, BigDecimal bd2) {
        return BigDecimalUtil.nullToZero(bd1).subtract(BigDecimalUtil.nullToZero(bd2));
    }
}

