/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.merge;

import com.alibaba.fastjson.JSON;
import com.xforceplus.adapter.component.merge.AbstractMergeAdapter;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.client.ReceiptMergeToolsClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.receipt.dto.config.CombinationField;
import com.xforceplus.receipt.vo.request.BillMergeRequest;
import com.xforceplus.receipt.vo.request.MergeToolsRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.BillMergeParser;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillAutoMergeAdapter
extends AbstractMergeAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillAutoMergeAdapter.class);
    @Autowired
    private BillMainClient billMainClient;
    @Autowired
    private ReceiptMergeToolsClient receiptMergeToolsClient;
    @Autowired
    private BillMergeParser billMergeParser;
    private final List<CombinationField> baseConditions = this.baseCondition();

    public Object process(AdapterParams adapterParams) {
        Map paramMap = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        Object action = adapterParams.getParams().get("action");
        String associationConditionConfirm = String.valueOf(adapterParams.getParams().get("associationConditionConfirm"));
        String loanItem = String.valueOf(adapterParams.getParams().get("loanItem"));
        Map extOutOrdSalesbillDetailVO2CombRuleMap = (Map)paramMap.get("extOutOrdSalesbillDetailVO2CombRuleMap");
        MakeOutInvoiceResponse failResponse = new MakeOutInvoiceResponse().code(Response.Fail);
        List outSplitGroupList = (List)paramMap.get("outSplitGroupList");
        ArrayList<BillMergeRequest> requestBody = new ArrayList<BillMergeRequest>();
        boolean mergeAndSave = Objects.nonNull(action) && Objects.equals("MERGE", action);
        HashMap<List<OrdSalesbillDetailVO>, BillMergerRuleDTO> detailVoAndRule = new HashMap<List<OrdSalesbillDetailVO>, BillMergerRuleDTO>();
        for (Map.Entry ruleEntry : extOutOrdSalesbillDetailVO2CombRuleMap.entrySet()) {
            BillMergerRuleDTO ruleBean;
            MsConfigBean bean = (MsConfigBean)ruleEntry.getValue();
            List itemList = bean.getItemList();
            BillMergerRuleDTO billMergerRuleDTO = ruleBean = this.billMergeParser.parse(itemList);
            if (associationConditionConfirm != null && !Objects.equals(associationConditionConfirm, "null")) {
                billMergerRuleDTO.setAutoAssociationFlag(associationConditionConfirm);
            }
            log.info("MergeRule{}", (Object)JSON.toJSONString((Object)billMergerRuleDTO));
            log.info("\u7ec4\u5408\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoAssociationFlag());
            log.info("\u5408\u5e76\u6807\u8bc6:{}", (Object)billMergerRuleDTO.getAutoMergeFlag());
            log.info("RuleId{}", (Object)billMergerRuleDTO.getRuldId());
            List vo = (List)ruleEntry.getKey();
            if (mergeAndSave) {
                BillMergeRequest billMergeRequest = this.prepareMergeRequest(billMergerRuleDTO, vo, tenantId, loanItem);
                requestBody.add(billMergeRequest);
                detailVoAndRule.put((List)ruleEntry.getKey(), billMergerRuleDTO);
                continue;
            }
            MakeOutInvoiceResponse makeOutInvoiceResponse = this.requestMerge(() -> {
                log.info("\u4ec5\u5408\u5e76");
                MergeToolsRequest mergeToolsRequest = this.prepareMergeToolsRequest(billMergerRuleDTO, vo, tenantId);
                return this.receiptMergeToolsClient.merge(tenantId, mergeToolsRequest);
            }, outSplitGroupList, billMergerRuleDTO, (List<OrdSalesbillDetailVO>)vo);
            if (!Objects.nonNull(makeOutInvoiceResponse) || !Objects.equals(makeOutInvoiceResponse.getCode(), Response.Fail)) continue;
            log.info("\u4ec5\u5408\u5e76\u5931\u8d25:{}", (Object)makeOutInvoiceResponse.getMessage());
            return makeOutInvoiceResponse;
        }
        if (mergeAndSave && !requestBody.isEmpty()) {
            log.info("\u6279\u91cf\u5408\u5e76\u5e76\u843d\u5e93");
            MakeOutInvoiceResponse makeOutInvoiceResponse = this.batchRequestMerge(() -> this.billMainClient.mergeAutoBatch(tenantId, requestBody), outSplitGroupList, detailVoAndRule);
            if (Objects.nonNull(makeOutInvoiceResponse) && Objects.equals(makeOutInvoiceResponse.getCode(), Response.Fail)) {
                log.info("\u6279\u91cf\u5408\u5e76\u5931\u8d25:{}", (Object)makeOutInvoiceResponse.getMessage());
                return makeOutInvoiceResponse;
            }
        }
        return null;
    }

    private List<CombinationField> baseCondition() {
        return Arrays.asList(new CombinationField(CombinationField.FieldType.MAIN, "sellerGroupId"), new CombinationField(CombinationField.FieldType.MAIN, "sellerTaxNo"), new CombinationField(CombinationField.FieldType.MAIN, "sellerName"), new CombinationField(CombinationField.FieldType.MAIN, "purchaserGroupId"), new CombinationField(CombinationField.FieldType.MAIN, "purchaserTaxNo"), new CombinationField(CombinationField.FieldType.MAIN, "purchaserName"), new CombinationField(CombinationField.FieldType.MAIN, "billType"), new CombinationField(CombinationField.FieldType.ITEM_PRIORITY, "invoiceType"));
    }

    public String adapterName() {
        return "salesBillGroup";
    }
}

