/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.receipt.enums.SourceRelationTypeFlag;
import com.xforceplus.receipt.vo.BillItem;
import com.xforceplus.receipt.vo.response.Response;
import com.xforceplus.xplatsecurity.util.CommonTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ValidateBillItemByAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(ValidateBillItemByAdapter.class);
    @Autowired
    private BillItemClient itemClient;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        List billIdList = (List)params.get("billIdList");
        if (CollectionUtils.isEmpty((Collection)billIdList)) {
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a!");
        }
        Response response = this.itemClient.queryBillItemByBillId(tenantId, billIdList);
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        List notMatchedBillNoList = result.stream().filter(item -> item.getOrigin().intValue() != SourceRelationTypeFlag.ORIGINAL.value().intValue()).map(item -> item.getBillNo()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notMatchedBillNoList)) {
            String billNoString = Joiner.on((String)",").join(notMatchedBillNoList);
            billNoString = CommonTools.subString((String)billNoString, (int)2000);
            return com.xforceplus.xplatframework.model.Response.failed((String)("\u4e1a\u52a1\u5355\u5df2\u7ecf\u88ab\u62c6\u5206\u6216\u5408\u5e76\uff0c\u5982\u8981\u8f6c\u6362\u8bf7\u5148\u64a4\u56de\u62c6\u5206\u5408\u5e76\u6062\u590d\u5230\u539f\u59cb\u4e1a\u52a1\u5355\u3002\u4e1a\u52a1\u5355\u53f7\uff1a\u3010" + billNoString + "\u3011"));
        }
        HashSet outBatchNoSet = Sets.newHashSet();
        ArrayList outItemIdWithBatchNoList = Lists.newArrayList();
        result.forEach(item -> {
            if (item.getBatchNo() > 0L) {
                outBatchNoSet.add(item.getBatchNo());
            }
            if (item.getId() > 0L) {
                outItemIdWithBatchNoList.add(item.getId());
            }
        });
        Map collect = result.stream().filter(i -> Objects.nonNull(i.getBatchNo()) && i.getBatchNo() != 0L).collect(Collectors.groupingBy(BillItem::getBatchNo, Collectors.mapping(i -> i.getBillNo(), Collectors.toSet())));
        for (Map.Entry entry : collect.entrySet()) {
            Set value = entry.getValue();
            if (value.size() <= 1) continue;
            return com.xforceplus.xplatframework.model.Response.failed((String)"\u4e1a\u52a1\u5355\u5df2\u901a\u8fc7\u7ec4\u5408\u5408\u5e76\u751f\u6210\u9884\u5236\u53d1\u7968,\u5982\u8981\u8f6c\u6362\u8bf7\u5148\u5220\u9664\u4e1a\u52a1\u5355\u4e0b\u9884\u5236\u53d1\u7968.");
        }
        HashMap map = Maps.newHashMap();
        map.put("outBatchNoSet", outBatchNoSet);
        map.put("itemIdWithBatchNoList", outItemIdWithBatchNoList);
        return com.xforceplus.xplatframework.model.Response.ok((String)"\u6821\u9a8c\u901a\u8fc7!", (Object)map);
    }

    public String adapterName() {
        return "validateBillItemBy";
    }
}

