/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component;

import com.google.common.collect.Lists;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.phoenix.bill.client.api.adapter.BillOperationAdapterService;
import com.xforceplus.phoenix.bill.client.api.adapter.model.BillMatchInvoiceVo;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceStatus;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillMatchInvoiceComponent {
    @Autowired
    private BillMainClient mainClient;
    @Autowired
    private BillOperationAdapterService operationAdapterService;

    public List<BillMatchInvoiceVo> createVo(List<Long> billIds, Long invoiceId, String invoiceNo, String invoiceCode, Integer invoiceOrigin, String tenantId) {
        ArrayList matchInvoiceVos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(billIds)) {
            List<List<Long>> lists = this.averageAssign(billIds, 2000);
            for (List<Long> list : lists) {
                BillMainQueryRequest request = new BillMainQueryRequest();
                request.setBillIds(list);
                Response response = this.mainClient.queryBills(tenantId, request);
                List result = (List)response.getResult();
                if (CollectionUtils.isEmpty((Collection)result)) continue;
                matchInvoiceVos.addAll(result.stream().map(bill -> {
                    BillMatchInvoiceVo osbm = new BillMatchInvoiceVo();
                    osbm.setInvoiceId(invoiceId);
                    osbm.setInvoiceCode(invoiceCode);
                    osbm.setInvoiceNo(invoiceNo);
                    osbm.setSalesbillNo(bill.getBillNo());
                    osbm.setAmountWithoutTax(bill.getAmountWithoutTax());
                    osbm.setAmountWithTax(bill.getAmountWithTax());
                    osbm.setTaxAmount(bill.getTaxAmount());
                    osbm.setSalesbillId(bill.getId());
                    osbm.setOpType(invoiceOrigin);
                    osbm.setStatus(BillInvoiceStatus.MatchedBill.value());
                    return osbm;
                }).collect(Collectors.toList()));
            }
        }
        return matchInvoiceVos;
    }

    public void saveBillMatchInvoice(List<BillMatchInvoiceVo> matchInvoiceVos) {
        this.operationAdapterService.saveBillMatchInvoice(matchInvoiceVos);
    }

    public <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}

