/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillItemClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillItemInfoMapper;
import com.xforceplus.phoenix.bill.client.model.BillDetailListResponse;
import com.xforceplus.phoenix.bill.client.model.GetBillItemsListRequest;
import com.xforceplus.receipt.vo.response.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillSourceDeletedItemQueryAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(BillSourceDeletedItemQueryAdapter.class);
    @Autowired
    private BillItemClient billItemClient;
    @Autowired
    private BillItemInfoMapper billItemInfoMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        Map params = adapterParams.getParams();
        String tenantId = adapterParams.getTenantId();
        GetBillItemsListRequest request = (GetBillItemsListRequest)params.get("getBillItemsListRequest");
        Long salesBillId = request.getSalesBillId();
        Response response = this.billItemClient.getSourceDeleteItemsByNewBillId(tenantId, salesBillId);
        BillDetailListResponse billDetailListResponse = new BillDetailListResponse();
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            billDetailListResponse.setMessage("\u672a\u67e5\u8be2\u5230\u7ed3\u679c.");
        } else {
            billDetailListResponse.setResult(this.billItemInfoMapper.mapToBillItemInfos((List)response.getResult()));
            billDetailListResponse.setMessage("\u67e5\u8be2\u6210\u529f!");
        }
        return billDetailListResponse;
    }

    public String adapterName() {
        return "querySourceDeletedItemsByNewBillId";
    }
}

