/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.xforceplus.adapter.core.client.BillRelationClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.adapter.mapstruct.BillItemInfoMapper;
import com.xforceplus.phoenix.bill.client.model.BillAutoItemResponse;
import com.xforceplus.receipt.vo.response.Response;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class QueryAutoBillItemAdapter
implements IAdapter<AdapterParams, Object> {
    @Autowired
    private BillRelationClient billItemClient;
    @Autowired
    private BillItemInfoMapper billItemInfoMapper;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        Long batchNo = (Long)params.get("batchNo");
        Response listResponse = this.billItemClient.queryOriginBillItem(tenantId, batchNo);
        BillAutoItemResponse response = new BillAutoItemResponse();
        if (listResponse.isOk()) {
            response.setCode(BillAutoItemResponse.OK);
            response.setResult(this.billItemInfoMapper.mapToOriginVOs((List)listResponse.getResult()));
        } else {
            response.setCode(BillAutoItemResponse.Fail);
            response.setMessage(listResponse.getMessage());
        }
        return response;
    }

    public String adapterName() {
        return "queryAutoBillItem";
    }
}

