/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.adapter.component.query;

import com.google.common.base.Joiner;
import com.xforceplus.adapter.core.client.BillMainClient;
import com.xforceplus.adapter.core.component.IAdapter;
import com.xforceplus.adapter.core.processor.AdapterParams;
import com.xforceplus.receipt.vo.request.BillMainQueryRequest;
import com.xforceplus.xplatframework.model.Response;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ValidateBillFromDbAdapter
implements IAdapter<AdapterParams, Object> {
    private static final Logger log = LoggerFactory.getLogger(ValidateBillFromDbAdapter.class);
    @Autowired
    private BillMainClient mainClient;

    @Retryable(value={Throwable.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, multiplier=1.5))
    public Object process(AdapterParams adapterParams) {
        String tenantId = adapterParams.getTenantId();
        Map params = adapterParams.getParams();
        List billIds = (List)params.get("billIdList");
        if (CollectionUtils.isEmpty((Collection)billIds)) {
            return Response.failed((String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BillMainQueryRequest request = new BillMainQueryRequest();
        request.setBillIds(billIds);
        com.xforceplus.receipt.vo.response.Response response = this.mainClient.queryBills(tenantId, request);
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Response.failed((String)"\u6570\u636e\u540c\u6b65\u51fa\u73b0\u5f02\u5e38!");
        }
        List notMatchedBillNoList = result.stream().filter(bill -> bill.getAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0 || bill.getAlreadyMakeAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0 || bill.getFreezeAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0).map(bill -> bill.getBillNo()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notMatchedBillNoList)) {
            String billNoString = Joiner.on((String)",").join(notMatchedBillNoList);
            billNoString = StringUtils.substring((String)billNoString, (int)0, (int)2000);
            return Response.failed((String)("\u4e1a\u52a1\u5355\u5df2\u5f00\u7968\u6216\u90e8\u5206\u5df2\u5f00\u7968\uff0c\u4e0d\u53ef\u4ee5\u8f6c\u6362\u4e3a\u5f00\u7968\u5355\u636e.\u4e1a\u52a1\u5355\u53f7:" + billNoString));
        }
        return null;
    }

    public String adapterName() {
        return "validateBillFromDb";
    }
}

